@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The provisioned state of the resource.
 */
public enum class ProvisioningState(
    public val javaValue: com.pulumi.azurenative.providerhub.enums.ProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.enums.ProvisioningState> {
    NotSpecified(com.pulumi.azurenative.providerhub.enums.ProvisioningState.NotSpecified),
    Accepted(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Accepted),
    Running(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Running),
    Creating(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Creating),
    Created(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Created),
    Deleting(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Deleting),
    Deleted(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Deleted),
    Canceled(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Canceled),
    Failed(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Failed),
    Succeeded(com.pulumi.azurenative.providerhub.enums.ProvisioningState.Succeeded),
    MovingResources(com.pulumi.azurenative.providerhub.enums.ProvisioningState.MovingResources),
    TransientFailure(com.pulumi.azurenative.providerhub.enums.ProvisioningState.TransientFailure),
    RolloutInProgress(com.pulumi.azurenative.providerhub.enums.ProvisioningState.RolloutInProgress),
    ;

    override fun toJava(): com.pulumi.azurenative.providerhub.enums.ProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.enums.ProvisioningState): ProvisioningState = ProvisioningState.values().first { it.javaValue == javaType }
    }
}
