@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.AuthorizationActionMappingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property desired
 * @property original
 */
public data class AuthorizationActionMappingArgs(
    public val desired: Output<String>? = null,
    public val original: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.AuthorizationActionMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.AuthorizationActionMappingArgs =
        com.pulumi.azurenative.providerhub.inputs.AuthorizationActionMappingArgs.builder()
            .desired(desired?.applyValue({ args0 -> args0 }))
            .original(original?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationActionMappingArgs].
 */
@PulumiTagMarker
public class AuthorizationActionMappingArgsBuilder internal constructor() {
    private var desired: Output<String>? = null

    private var original: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ucyyxofdmnyrauym")
    public suspend fun desired(`value`: Output<String>) {
        this.desired = value
    }

    /**
     * @param value
     */
    @JvmName("fbuicndrffokaclx")
    public suspend fun original(`value`: Output<String>) {
        this.original = value
    }

    /**
     * @param value
     */
    @JvmName("ywomumjpehrcrbks")
    public suspend fun desired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desired = mapped
    }

    /**
     * @param value
     */
    @JvmName("vqkodjctkyobpkbb")
    public suspend fun original(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.original = mapped
    }

    internal fun build(): AuthorizationActionMappingArgs = AuthorizationActionMappingArgs(
        desired = desired,
        original = original,
    )
}
