@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property regions
 * @property skipRegions
 */
public data class DefaultRolloutSpecificationCanaryArgs(
    public val regions: Output<List<String>>? = null,
    public val skipRegions: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs =
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationCanaryArgs.builder()
            .regions(regions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .skipRegions(skipRegions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DefaultRolloutSpecificationCanaryArgs].
 */
@PulumiTagMarker
public class DefaultRolloutSpecificationCanaryArgsBuilder internal constructor() {
    private var regions: Output<List<String>>? = null

    private var skipRegions: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("gckeqggqkmpetqbv")
    public suspend fun regions(`value`: Output<List<String>>) {
        this.regions = value
    }

    @JvmName("qknlcbtxwdrjxmib")
    public suspend fun regions(vararg values: Output<String>) {
        this.regions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ellobjdjximhhfcl")
    public suspend fun regions(values: List<Output<String>>) {
        this.regions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("gpclhgkmqamtkhgb")
    public suspend fun skipRegions(`value`: Output<List<String>>) {
        this.skipRegions = value
    }

    @JvmName("ngijkauivkojvirx")
    public suspend fun skipRegions(vararg values: Output<String>) {
        this.skipRegions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("pnwhxkpwyxnvvvdt")
    public suspend fun skipRegions(values: List<Output<String>>) {
        this.skipRegions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ygsgtvdlvhymoyia")
    public suspend fun regions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param values
     */
    @JvmName("rehmmaujamrslrlk")
    public suspend fun regions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regions = mapped
    }

    /**
     * @param value
     */
    @JvmName("wgkgelcerigsvtxg")
    public suspend fun skipRegions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipRegions = mapped
    }

    /**
     * @param values
     */
    @JvmName("lfkuryrjayquywsv")
    public suspend fun skipRegions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.skipRegions = mapped
    }

    internal fun build(): DefaultRolloutSpecificationCanaryArgs =
        DefaultRolloutSpecificationCanaryArgs(
            regions = regions,
            skipRegions = skipRegions,
        )
}
