@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationExpeditedRolloutArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Indicates whether expedited rollout is enabled/disabled
 */
public data class DefaultRolloutSpecificationExpeditedRolloutArgs(
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationExpeditedRolloutArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationExpeditedRolloutArgs =
        com.pulumi.azurenative.providerhub.inputs.DefaultRolloutSpecificationExpeditedRolloutArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultRolloutSpecificationExpeditedRolloutArgs].
 */
@PulumiTagMarker
public class DefaultRolloutSpecificationExpeditedRolloutArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Indicates whether expedited rollout is enabled/disabled
     */
    @JvmName("uvhlsavowrcgspvo")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Indicates whether expedited rollout is enabled/disabled
     */
    @JvmName("johdhkcfstmiydey")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefaultRolloutSpecificationExpeditedRolloutArgs =
        DefaultRolloutSpecificationExpeditedRolloutArgs(
            enabled = enabled,
        )
}
