@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ExtendedLocationOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property supportedPolicy
 * @property type
 */
public data class ExtendedLocationOptionsArgs(
    public val supportedPolicy: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ExtendedLocationOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ExtendedLocationOptionsArgs =
        com.pulumi.azurenative.providerhub.inputs.ExtendedLocationOptionsArgs.builder()
            .supportedPolicy(supportedPolicy?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExtendedLocationOptionsArgs].
 */
@PulumiTagMarker
public class ExtendedLocationOptionsArgsBuilder internal constructor() {
    private var supportedPolicy: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xcdxmcjoyyjhfiwm")
    public suspend fun supportedPolicy(`value`: Output<String>) {
        this.supportedPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("qwtqqafdvviarwaa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("ysftuulirokvntfb")
    public suspend fun supportedPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportedPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("cbqoexwmlbrsspyj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ExtendedLocationOptionsArgs = ExtendedLocationOptionsArgs(
        supportedPolicy = supportedPolicy,
        type = type,
    )
}
