@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.GetDefaultRolloutPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property rolloutName The rollout name.
 */
public data class GetDefaultRolloutPlainArgs(
    public val providerNamespace: String,
    public val rolloutName: String,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.GetDefaultRolloutPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.GetDefaultRolloutPlainArgs =
        com.pulumi.azurenative.providerhub.inputs.GetDefaultRolloutPlainArgs.builder()
            .providerNamespace(providerNamespace.let({ args0 -> args0 }))
            .rolloutName(rolloutName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDefaultRolloutPlainArgs].
 */
@PulumiTagMarker
public class GetDefaultRolloutPlainArgsBuilder internal constructor() {
    private var providerNamespace: String? = null

    private var rolloutName: String? = null

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("rrhiufkddrjdftqp")
    public suspend fun providerNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerNamespace = mapped
    }

    /**
     * @param value The rollout name.
     */
    @JvmName("eselqhfvwrsyskei")
    public suspend fun rolloutName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.rolloutName = mapped
    }

    internal fun build(): GetDefaultRolloutPlainArgs = GetDefaultRolloutPlainArgs(
        providerNamespace = providerNamespace ?: throw PulumiNullFieldException("providerNamespace"),
        rolloutName = rolloutName ?: throw PulumiNullFieldException("rolloutName"),
    )
}
