@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.GetNotificationRegistrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property notificationRegistrationName The notification registration.
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 */
public data class GetNotificationRegistrationPlainArgs(
    public val notificationRegistrationName: String,
    public val providerNamespace: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.GetNotificationRegistrationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.GetNotificationRegistrationPlainArgs =
        com.pulumi.azurenative.providerhub.inputs.GetNotificationRegistrationPlainArgs.builder()
            .notificationRegistrationName(notificationRegistrationName.let({ args0 -> args0 }))
            .providerNamespace(providerNamespace.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNotificationRegistrationPlainArgs].
 */
@PulumiTagMarker
public class GetNotificationRegistrationPlainArgsBuilder internal constructor() {
    private var notificationRegistrationName: String? = null

    private var providerNamespace: String? = null

    /**
     * @param value The notification registration.
     */
    @JvmName("nuskvkyvsupydmks")
    public suspend fun notificationRegistrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.notificationRegistrationName = mapped
    }

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("cknqahfvpcsrihmt")
    public suspend fun providerNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerNamespace = mapped
    }

    internal fun build(): GetNotificationRegistrationPlainArgs = GetNotificationRegistrationPlainArgs(
        notificationRegistrationName = notificationRegistrationName ?: throw
            PulumiNullFieldException("notificationRegistrationName"),
        providerNamespace = providerNamespace ?: throw PulumiNullFieldException("providerNamespace"),
    )
}
