@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.GetResourceTypeRegistrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property providerNamespace The name of the resource provider hosted within ProviderHub.
 * @property resourceType The resource type.
 */
public data class GetResourceTypeRegistrationPlainArgs(
    public val providerNamespace: String,
    public val resourceType: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.GetResourceTypeRegistrationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.GetResourceTypeRegistrationPlainArgs =
        com.pulumi.azurenative.providerhub.inputs.GetResourceTypeRegistrationPlainArgs.builder()
            .providerNamespace(providerNamespace.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceTypeRegistrationPlainArgs].
 */
@PulumiTagMarker
public class GetResourceTypeRegistrationPlainArgsBuilder internal constructor() {
    private var providerNamespace: String? = null

    private var resourceType: String? = null

    /**
     * @param value The name of the resource provider hosted within ProviderHub.
     */
    @JvmName("xfldevhlskkhwyix")
    public suspend fun providerNamespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerNamespace = mapped
    }

    /**
     * @param value The resource type.
     */
    @JvmName("juamwbarerbxsmib")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetResourceTypeRegistrationPlainArgs = GetResourceTypeRegistrationPlainArgs(
        providerNamespace = providerNamespace ?: throw PulumiNullFieldException("providerNamespace"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
