@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.OpenApiConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property validation
 */
public data class OpenApiConfigurationArgs(
    public val validation: Output<OpenApiValidationArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.OpenApiConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.OpenApiConfigurationArgs =
        com.pulumi.azurenative.providerhub.inputs.OpenApiConfigurationArgs.builder()
            .validation(validation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [OpenApiConfigurationArgs].
 */
@PulumiTagMarker
public class OpenApiConfigurationArgsBuilder internal constructor() {
    private var validation: Output<OpenApiValidationArgs>? = null

    /**
     * @param value
     */
    @JvmName("yvltghvsaiipehwy")
    public suspend fun validation(`value`: Output<OpenApiValidationArgs>) {
        this.validation = value
    }

    /**
     * @param value
     */
    @JvmName("lqmgehakcbjphvng")
    public suspend fun validation(`value`: OpenApiValidationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validation = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gwtcevqpjhhjndjw")
    public suspend fun validation(argument: suspend OpenApiValidationArgsBuilder.() -> Unit) {
        val toBeMapped = OpenApiValidationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.validation = mapped
    }

    internal fun build(): OpenApiConfigurationArgs = OpenApiConfigurationArgs(
        validation = validation,
    )
}
