@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceConcurrencyControlOptionArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.Policy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property policy
 */
public data class ResourceConcurrencyControlOptionArgs(
    public val policy: Output<Either<String, Policy>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceConcurrencyControlOptionArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceConcurrencyControlOptionArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceConcurrencyControlOptionArgs.builder()
            .policy(
                policy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceConcurrencyControlOptionArgs].
 */
@PulumiTagMarker
public class ResourceConcurrencyControlOptionArgsBuilder internal constructor() {
    private var policy: Output<Either<String, Policy>>? = null

    /**
     * @param value
     */
    @JvmName("wvuhrvpttbktwfjq")
    public suspend fun policy(`value`: Output<Either<String, Policy>>) {
        this.policy = value
    }

    /**
     * @param value
     */
    @JvmName("qltjqnsqbqylrpjw")
    public suspend fun policy(`value`: Either<String, Policy>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value
     */
    @JvmName("nmmoqkulmydamcmh")
    public fun policy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Policy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value
     */
    @JvmName("ufgmexqcvmckmugx")
    public fun policy(`value`: Policy) {
        val toBeMapped = Either.ofRight<String, Policy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): ResourceConcurrencyControlOptionArgs = ResourceConcurrencyControlOptionArgs(
        policy = policy,
    )
}
