@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesManagementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property incidentContactEmail
 * @property incidentRoutingService
 * @property incidentRoutingTeam
 * @property manifestOwners
 * @property resourceAccessPolicy
 * @property resourceAccessRoles
 * @property schemaOwners
 * @property serviceTreeInfos
 */
public data class ResourceProviderManifestPropertiesManagementArgs(
    public val incidentContactEmail: Output<String>? = null,
    public val incidentRoutingService: Output<String>? = null,
    public val incidentRoutingTeam: Output<String>? = null,
    public val manifestOwners: Output<List<String>>? = null,
    public val resourceAccessPolicy: Output<String>? = null,
    public val resourceAccessRoles: Output<List<Any>>? = null,
    public val schemaOwners: Output<List<String>>? = null,
    public val serviceTreeInfos: Output<List<ServiceTreeInfoArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesManagementArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesManagementArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesManagementArgs.builder()
            .incidentContactEmail(incidentContactEmail?.applyValue({ args0 -> args0 }))
            .incidentRoutingService(incidentRoutingService?.applyValue({ args0 -> args0 }))
            .incidentRoutingTeam(incidentRoutingTeam?.applyValue({ args0 -> args0 }))
            .manifestOwners(manifestOwners?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceAccessPolicy(resourceAccessPolicy?.applyValue({ args0 -> args0 }))
            .resourceAccessRoles(resourceAccessRoles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .schemaOwners(schemaOwners?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .serviceTreeInfos(
                serviceTreeInfos?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceProviderManifestPropertiesManagementArgs].
 */
@PulumiTagMarker
public class ResourceProviderManifestPropertiesManagementArgsBuilder internal constructor() {
    private var incidentContactEmail: Output<String>? = null

    private var incidentRoutingService: Output<String>? = null

    private var incidentRoutingTeam: Output<String>? = null

    private var manifestOwners: Output<List<String>>? = null

    private var resourceAccessPolicy: Output<String>? = null

    private var resourceAccessRoles: Output<List<Any>>? = null

    private var schemaOwners: Output<List<String>>? = null

    private var serviceTreeInfos: Output<List<ServiceTreeInfoArgs>>? = null

    /**
     * @param value
     */
    @JvmName("hqichjkwsvdmnjiq")
    public suspend fun incidentContactEmail(`value`: Output<String>) {
        this.incidentContactEmail = value
    }

    /**
     * @param value
     */
    @JvmName("ryeaxrpvclsgemir")
    public suspend fun incidentRoutingService(`value`: Output<String>) {
        this.incidentRoutingService = value
    }

    /**
     * @param value
     */
    @JvmName("vpsiyoqkqaarkche")
    public suspend fun incidentRoutingTeam(`value`: Output<String>) {
        this.incidentRoutingTeam = value
    }

    /**
     * @param value
     */
    @JvmName("wqknrvboggurevps")
    public suspend fun manifestOwners(`value`: Output<List<String>>) {
        this.manifestOwners = value
    }

    @JvmName("ljusqfqrwfgbcwvn")
    public suspend fun manifestOwners(vararg values: Output<String>) {
        this.manifestOwners = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("bavgkdwfxsyjijfm")
    public suspend fun manifestOwners(values: List<Output<String>>) {
        this.manifestOwners = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("nxbkfbfpootrbjof")
    public suspend fun resourceAccessPolicy(`value`: Output<String>) {
        this.resourceAccessPolicy = value
    }

    /**
     * @param value
     */
    @JvmName("joxnfcmfhswbkgla")
    public suspend fun resourceAccessRoles(`value`: Output<List<Any>>) {
        this.resourceAccessRoles = value
    }

    @JvmName("kbwrouequililbds")
    public suspend fun resourceAccessRoles(vararg values: Output<Any>) {
        this.resourceAccessRoles = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("fvsoitgsqednuqnu")
    public suspend fun resourceAccessRoles(values: List<Output<Any>>) {
        this.resourceAccessRoles = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qjwecxibbxchdgba")
    public suspend fun schemaOwners(`value`: Output<List<String>>) {
        this.schemaOwners = value
    }

    @JvmName("tjootgqjjigsqtof")
    public suspend fun schemaOwners(vararg values: Output<String>) {
        this.schemaOwners = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ewhqadxqhgrimgnn")
    public suspend fun schemaOwners(values: List<Output<String>>) {
        this.schemaOwners = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("lnamnxbnpcrbdtrc")
    public suspend fun serviceTreeInfos(`value`: Output<List<ServiceTreeInfoArgs>>) {
        this.serviceTreeInfos = value
    }

    @JvmName("wpliaeeqolmaqskj")
    public suspend fun serviceTreeInfos(vararg values: Output<ServiceTreeInfoArgs>) {
        this.serviceTreeInfos = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tovdugonujcdgccx")
    public suspend fun serviceTreeInfos(values: List<Output<ServiceTreeInfoArgs>>) {
        this.serviceTreeInfos = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("dhbfjfvbcurtfujx")
    public suspend fun incidentContactEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentContactEmail = mapped
    }

    /**
     * @param value
     */
    @JvmName("nkpjdbauvoiolwyt")
    public suspend fun incidentRoutingService(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentRoutingService = mapped
    }

    /**
     * @param value
     */
    @JvmName("knscfgqsxrrvxtty")
    public suspend fun incidentRoutingTeam(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.incidentRoutingTeam = mapped
    }

    /**
     * @param value
     */
    @JvmName("elwpdheoklkchjga")
    public suspend fun manifestOwners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manifestOwners = mapped
    }

    /**
     * @param values
     */
    @JvmName("fcdxxudeiegtpjnp")
    public suspend fun manifestOwners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.manifestOwners = mapped
    }

    /**
     * @param value
     */
    @JvmName("wrvsqvlncnllnpvk")
    public suspend fun resourceAccessPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAccessPolicy = mapped
    }

    /**
     * @param value
     */
    @JvmName("rrtdsephkeothnah")
    public suspend fun resourceAccessRoles(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAccessRoles = mapped
    }

    /**
     * @param values
     */
    @JvmName("fiqucphscedleqxh")
    public suspend fun resourceAccessRoles(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceAccessRoles = mapped
    }

    /**
     * @param value
     */
    @JvmName("iucmqxxvnraobrtj")
    public suspend fun schemaOwners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schemaOwners = mapped
    }

    /**
     * @param values
     */
    @JvmName("ckddqnskrynsfgdp")
    public suspend fun schemaOwners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaOwners = mapped
    }

    /**
     * @param value
     */
    @JvmName("msvjseioftetnaqw")
    public suspend fun serviceTreeInfos(`value`: List<ServiceTreeInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xbsnqsaowbnhyjpy")
    public suspend fun serviceTreeInfos(argument: List<suspend ServiceTreeInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceTreeInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lmlngdfiwivoflfy")
    public suspend fun serviceTreeInfos(vararg argument: suspend ServiceTreeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceTreeInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cwomshbmgfmompcf")
    public suspend fun serviceTreeInfos(argument: suspend ServiceTreeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceTreeInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceTreeInfos = mapped
    }

    /**
     * @param values
     */
    @JvmName("qbujfhcdtyfaosee")
    public suspend fun serviceTreeInfos(vararg values: ServiceTreeInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceTreeInfos = mapped
    }

    internal fun build(): ResourceProviderManifestPropertiesManagementArgs =
        ResourceProviderManifestPropertiesManagementArgs(
            incidentContactEmail = incidentContactEmail,
            incidentRoutingService = incidentRoutingService,
            incidentRoutingTeam = incidentRoutingTeam,
            manifestOwners = manifestOwners,
            resourceAccessPolicy = resourceAccessPolicy,
            resourceAccessRoles = resourceAccessRoles,
            schemaOwners = schemaOwners,
            serviceTreeInfos = serviceTreeInfos,
        )
}
