@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.PreflightOption
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property preflightOptions
 * @property preflightSupported
 */
public data class ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs(
    public val preflightOptions: Output<List<Either<String, PreflightOption>>>? = null,
    public val preflightSupported: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs.builder()
            .preflightOptions(
                preflightOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .preflightSupported(preflightSupported?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs].
 */
@PulumiTagMarker
public class ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgsBuilder internal constructor() {
    private var preflightOptions: Output<List<Either<String, PreflightOption>>>? = null

    private var preflightSupported: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("bvxrhcyuhyxhupik")
    public suspend fun preflightOptions(`value`: Output<List<Either<String, PreflightOption>>>) {
        this.preflightOptions = value
    }

    @JvmName("mjhrfccklnynnswm")
    public suspend fun preflightOptions(vararg values: Output<Either<String, PreflightOption>>) {
        this.preflightOptions = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("rtmavohagvkelnfe")
    public suspend fun preflightOptions(values: List<Output<Either<String, PreflightOption>>>) {
        this.preflightOptions = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("orqmivvuvtthqonf")
    public suspend fun preflightSupported(`value`: Output<Boolean>) {
        this.preflightSupported = value
    }

    /**
     * @param value
     */
    @JvmName("ttnjxowvvmuxhbsr")
    public suspend fun preflightOptions(`value`: List<Either<String, PreflightOption>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preflightOptions = mapped
    }

    /**
     * @param values
     */
    @JvmName("ujhawjhppiguvtjo")
    public suspend fun preflightOptions(vararg values: Either<String, PreflightOption>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preflightOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("prntmxtnyamqtyua")
    public suspend fun preflightSupported(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preflightSupported = mapped
    }

    internal fun build(): ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs =
        ResourceProviderManifestPropertiesTemplateDeploymentOptionsArgs(
            preflightOptions = preflightOptions,
            preflightSupported = preflightSupported,
        )
}
