@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeExtensionArgs.builder
import com.pulumi.azurenative.providerhub.kotlin.enums.ExtensionCategory
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property endpointUri
 * @property extensionCategories
 * @property timeout
 */
public data class ResourceTypeExtensionArgs(
    public val endpointUri: Output<String>? = null,
    public val extensionCategories: Output<List<Either<String, ExtensionCategory>>>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceTypeExtensionArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeExtensionArgs.builder()
            .endpointUri(endpointUri?.applyValue({ args0 -> args0 }))
            .extensionCategories(
                extensionCategories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceTypeExtensionArgs].
 */
@PulumiTagMarker
public class ResourceTypeExtensionArgsBuilder internal constructor() {
    private var endpointUri: Output<String>? = null

    private var extensionCategories: Output<List<Either<String, ExtensionCategory>>>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("gyfeshxsyyblcram")
    public suspend fun endpointUri(`value`: Output<String>) {
        this.endpointUri = value
    }

    /**
     * @param value
     */
    @JvmName("ghliuedklddoqneo")
    public suspend fun extensionCategories(`value`: Output<List<Either<String, ExtensionCategory>>>) {
        this.extensionCategories = value
    }

    @JvmName("mnewmrscoakfralc")
    public suspend fun extensionCategories(vararg values: Output<Either<String, ExtensionCategory>>) {
        this.extensionCategories = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nxowujfhpdpbwcvd")
    public suspend fun extensionCategories(values: List<Output<Either<String, ExtensionCategory>>>) {
        this.extensionCategories = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cadqpypdsjmwvuap")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value
     */
    @JvmName("mslorfqdpqatwiwe")
    public suspend fun endpointUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointUri = mapped
    }

    /**
     * @param value
     */
    @JvmName("tovjtyshqalhdhxq")
    public suspend fun extensionCategories(`value`: List<Either<String, ExtensionCategory>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extensionCategories = mapped
    }

    /**
     * @param values
     */
    @JvmName("shstfixdcrkocvhd")
    public suspend fun extensionCategories(vararg values: Either<String, ExtensionCategory>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extensionCategories = mapped
    }

    /**
     * @param value
     */
    @JvmName("mogxossfwwjjxufj")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): ResourceTypeExtensionArgs = ResourceTypeExtensionArgs(
        endpointUri = endpointUri,
        extensionCategories = extensionCategories,
        timeout = timeout,
    )
}
