@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceMovePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property crossResourceGroupMoveEnabled
 * @property crossSubscriptionMoveEnabled
 * @property validationRequired
 */
public data class ResourceTypeRegistrationPropertiesResourceMovePolicyArgs(
    public val crossResourceGroupMoveEnabled: Output<Boolean>? = null,
    public val crossSubscriptionMoveEnabled: Output<Boolean>? = null,
    public val validationRequired: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceMovePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceMovePolicyArgs =
        com.pulumi.azurenative.providerhub.inputs.ResourceTypeRegistrationPropertiesResourceMovePolicyArgs.builder()
            .crossResourceGroupMoveEnabled(crossResourceGroupMoveEnabled?.applyValue({ args0 -> args0 }))
            .crossSubscriptionMoveEnabled(crossSubscriptionMoveEnabled?.applyValue({ args0 -> args0 }))
            .validationRequired(validationRequired?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceTypeRegistrationPropertiesResourceMovePolicyArgs].
 */
@PulumiTagMarker
public class ResourceTypeRegistrationPropertiesResourceMovePolicyArgsBuilder internal constructor() {
    private var crossResourceGroupMoveEnabled: Output<Boolean>? = null

    private var crossSubscriptionMoveEnabled: Output<Boolean>? = null

    private var validationRequired: Output<Boolean>? = null

    /**
     * @param value
     */
    @JvmName("gnpqfpkhkihswkfa")
    public suspend fun crossResourceGroupMoveEnabled(`value`: Output<Boolean>) {
        this.crossResourceGroupMoveEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("ykuucstbgjpfgruy")
    public suspend fun crossSubscriptionMoveEnabled(`value`: Output<Boolean>) {
        this.crossSubscriptionMoveEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("spdvstopinarmekn")
    public suspend fun validationRequired(`value`: Output<Boolean>) {
        this.validationRequired = value
    }

    /**
     * @param value
     */
    @JvmName("liakkelirsfqpdbc")
    public suspend fun crossResourceGroupMoveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossResourceGroupMoveEnabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("xghqtpohhxyqdlpv")
    public suspend fun crossSubscriptionMoveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossSubscriptionMoveEnabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("ogpjntgemetcykca")
    public suspend fun validationRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validationRequired = mapped
    }

    internal fun build(): ResourceTypeRegistrationPropertiesResourceMovePolicyArgs =
        ResourceTypeRegistrationPropertiesResourceMovePolicyArgs(
            crossResourceGroupMoveEnabled = crossResourceGroupMoveEnabled,
            crossSubscriptionMoveEnabled = crossSubscriptionMoveEnabled,
            validationRequired = validationRequired,
        )
}
