@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SkuLocationInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property extendedLocations
 * @property location
 * @property type
 * @property zoneDetails
 * @property zones
 */
public data class SkuLocationInfoArgs(
    public val extendedLocations: Output<List<String>>? = null,
    public val location: Output<String>,
    public val type: Output<String>? = null,
    public val zoneDetails: Output<List<SkuZoneDetailArgs>>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SkuLocationInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SkuLocationInfoArgs =
        com.pulumi.azurenative.providerhub.inputs.SkuLocationInfoArgs.builder()
            .extendedLocations(extendedLocations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .zoneDetails(
                zoneDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [SkuLocationInfoArgs].
 */
@PulumiTagMarker
public class SkuLocationInfoArgsBuilder internal constructor() {
    private var extendedLocations: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var type: Output<String>? = null

    private var zoneDetails: Output<List<SkuZoneDetailArgs>>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value
     */
    @JvmName("epggedfjcalwmoqo")
    public suspend fun extendedLocations(`value`: Output<List<String>>) {
        this.extendedLocations = value
    }

    @JvmName("cktoxpcfrtwkhrcy")
    public suspend fun extendedLocations(vararg values: Output<String>) {
        this.extendedLocations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("sairchkpwmivvcwi")
    public suspend fun extendedLocations(values: List<Output<String>>) {
        this.extendedLocations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("igsnslinibtwgvgy")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("aphnsgpebqpciurj")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("excvxymfrrfbgdaf")
    public suspend fun zoneDetails(`value`: Output<List<SkuZoneDetailArgs>>) {
        this.zoneDetails = value
    }

    @JvmName("hiynlgtypaqxeqdl")
    public suspend fun zoneDetails(vararg values: Output<SkuZoneDetailArgs>) {
        this.zoneDetails = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("dupeuyrdfcamkpng")
    public suspend fun zoneDetails(values: List<Output<SkuZoneDetailArgs>>) {
        this.zoneDetails = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("bwnaykmoifxemfjg")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("yutpceykwrsqymnu")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ymxodjvqtqpmihkn")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("cfkpqlndjgkyxopn")
    public suspend fun extendedLocations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocations = mapped
    }

    /**
     * @param values
     */
    @JvmName("fapvoyrgvtigcfah")
    public suspend fun extendedLocations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extendedLocations = mapped
    }

    /**
     * @param value
     */
    @JvmName("iuyseemmgcuwlgii")
    public suspend fun location(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("hkkobkyqtfgnbplj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("exnrmivnygjcevji")
    public suspend fun zoneDetails(`value`: List<SkuZoneDetailArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qhgadidtllvdivqw")
    public suspend fun zoneDetails(argument: List<suspend SkuZoneDetailArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SkuZoneDetailArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gprpwwwedndqrnaf")
    public suspend fun zoneDetails(vararg argument: suspend SkuZoneDetailArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SkuZoneDetailArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.zoneDetails = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bpsabhpauhfaiupm")
    public suspend fun zoneDetails(argument: suspend SkuZoneDetailArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuZoneDetailArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.zoneDetails = mapped
    }

    /**
     * @param values
     */
    @JvmName("tvgnklvvwinffxmm")
    public suspend fun zoneDetails(vararg values: SkuZoneDetailArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneDetails = mapped
    }

    /**
     * @param value
     */
    @JvmName("ydlkcgtgljnqajnh")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values
     */
    @JvmName("hajsxdhxbssafppn")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): SkuLocationInfoArgs = SkuLocationInfoArgs(
        extendedLocations = extendedLocations,
        location = location ?: throw PulumiNullFieldException("location"),
        type = type,
        zoneDetails = zoneDetails,
        zones = zones,
    )
}
