@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.inputs

import com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property capabilities
 * @property capacity
 * @property costs
 * @property family
 * @property kind
 * @property locationInfo
 * @property locations
 * @property name
 * @property requiredFeatures
 * @property requiredQuotaIds
 * @property size
 * @property tier
 */
public data class SkuSettingArgs(
    public val capabilities: Output<List<SkuCapabilityArgs>>? = null,
    public val capacity: Output<SkuSettingCapacityArgs>? = null,
    public val costs: Output<List<SkuCostArgs>>? = null,
    public val family: Output<String>? = null,
    public val kind: Output<String>? = null,
    public val locationInfo: Output<List<SkuLocationInfoArgs>>? = null,
    public val locations: Output<List<String>>? = null,
    public val name: Output<String>,
    public val requiredFeatures: Output<List<String>>? = null,
    public val requiredQuotaIds: Output<List<String>>? = null,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs =
        com.pulumi.azurenative.providerhub.inputs.SkuSettingArgs.builder()
            .capabilities(
                capabilities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .capacity(capacity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .costs(costs?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .family(family?.applyValue({ args0 -> args0 }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .locationInfo(
                locationInfo?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .locations(locations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .requiredFeatures(requiredFeatures?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .requiredQuotaIds(requiredQuotaIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuSettingArgs].
 */
@PulumiTagMarker
public class SkuSettingArgsBuilder internal constructor() {
    private var capabilities: Output<List<SkuCapabilityArgs>>? = null

    private var capacity: Output<SkuSettingCapacityArgs>? = null

    private var costs: Output<List<SkuCostArgs>>? = null

    private var family: Output<String>? = null

    private var kind: Output<String>? = null

    private var locationInfo: Output<List<SkuLocationInfoArgs>>? = null

    private var locations: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var requiredFeatures: Output<List<String>>? = null

    private var requiredQuotaIds: Output<List<String>>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("pxvqmuashmjbtjqh")
    public suspend fun capabilities(`value`: Output<List<SkuCapabilityArgs>>) {
        this.capabilities = value
    }

    @JvmName("hixubdnlhkbkjcgg")
    public suspend fun capabilities(vararg values: Output<SkuCapabilityArgs>) {
        this.capabilities = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("jgdfekkmgtwttrgt")
    public suspend fun capabilities(values: List<Output<SkuCapabilityArgs>>) {
        this.capabilities = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("qmtrmakuwvlscvew")
    public suspend fun capacity(`value`: Output<SkuSettingCapacityArgs>) {
        this.capacity = value
    }

    /**
     * @param value
     */
    @JvmName("dvoirsviwcdpttun")
    public suspend fun costs(`value`: Output<List<SkuCostArgs>>) {
        this.costs = value
    }

    @JvmName("hjlnfkxrjqwghfre")
    public suspend fun costs(vararg values: Output<SkuCostArgs>) {
        this.costs = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("sqmbvegaxkobmwrd")
    public suspend fun costs(values: List<Output<SkuCostArgs>>) {
        this.costs = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("sruqqspoevaafphj")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value
     */
    @JvmName("cnhtkffjubvfovpx")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value
     */
    @JvmName("wqimmrthwttyrgwj")
    public suspend fun locationInfo(`value`: Output<List<SkuLocationInfoArgs>>) {
        this.locationInfo = value
    }

    @JvmName("cmhrobrbgausfhrw")
    public suspend fun locationInfo(vararg values: Output<SkuLocationInfoArgs>) {
        this.locationInfo = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("laswntgwywseahmi")
    public suspend fun locationInfo(values: List<Output<SkuLocationInfoArgs>>) {
        this.locationInfo = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("afmvaxwknmsixtjd")
    public suspend fun locations(`value`: Output<List<String>>) {
        this.locations = value
    }

    @JvmName("duncjbsprbxkpsnh")
    public suspend fun locations(vararg values: Output<String>) {
        this.locations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("mjokxhvtpcjrgcmu")
    public suspend fun locations(values: List<Output<String>>) {
        this.locations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("daoxvtkggoopiwvp")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("rqjjtqftwewmgmlk")
    public suspend fun requiredFeatures(`value`: Output<List<String>>) {
        this.requiredFeatures = value
    }

    @JvmName("ervcierclvybvuky")
    public suspend fun requiredFeatures(vararg values: Output<String>) {
        this.requiredFeatures = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("khswtylnworwitwx")
    public suspend fun requiredFeatures(values: List<Output<String>>) {
        this.requiredFeatures = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("ekhtfojqllagqjvs")
    public suspend fun requiredQuotaIds(`value`: Output<List<String>>) {
        this.requiredQuotaIds = value
    }

    @JvmName("siejwvltsdjingog")
    public suspend fun requiredQuotaIds(vararg values: Output<String>) {
        this.requiredQuotaIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("nydcmmpwthhwxkbh")
    public suspend fun requiredQuotaIds(values: List<Output<String>>) {
        this.requiredQuotaIds = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("yakukakqiyepielq")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value
     */
    @JvmName("ktghmjdahurxdrdi")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value
     */
    @JvmName("vwsqdtrxwoeilxby")
    public suspend fun capabilities(`value`: List<SkuCapabilityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("icsykarctpqbbcrk")
    public suspend fun capabilities(argument: List<suspend SkuCapabilityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SkuCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("kvwrmaxmtlepyypv")
    public suspend fun capabilities(vararg argument: suspend SkuCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SkuCapabilityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("npajpvtrhtjlilps")
    public suspend fun capabilities(argument: suspend SkuCapabilityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuCapabilityArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.capabilities = mapped
    }

    /**
     * @param values
     */
    @JvmName("irugiacwbtavgytw")
    public suspend fun capabilities(vararg values: SkuCapabilityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capabilities = mapped
    }

    /**
     * @param value
     */
    @JvmName("giajinfpypaamakr")
    public suspend fun capacity(`value`: SkuSettingCapacityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jwdybdhrmgvtpiqf")
    public suspend fun capacity(argument: suspend SkuSettingCapacityArgsBuilder.() -> Unit) {
        val toBeMapped = SkuSettingCapacityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.capacity = mapped
    }

    /**
     * @param value
     */
    @JvmName("nauwmadbyiqsjojg")
    public suspend fun costs(`value`: List<SkuCostArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jfdlgxkgnvjxofnd")
    public suspend fun costs(argument: List<suspend SkuCostArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SkuCostArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lxssdvkmulewjmmq")
    public suspend fun costs(vararg argument: suspend SkuCostArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SkuCostArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hgkbwcsysetgdxvu")
    public suspend fun costs(argument: suspend SkuCostArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuCostArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.costs = mapped
    }

    /**
     * @param values
     */
    @JvmName("egmanharcingeskf")
    public suspend fun costs(vararg values: SkuCostArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.costs = mapped
    }

    /**
     * @param value
     */
    @JvmName("kjwkrkrjpckssfwi")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value
     */
    @JvmName("jhuvmwgddvnnqclq")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value
     */
    @JvmName("mdgmypllxhvrqahs")
    public suspend fun locationInfo(`value`: List<SkuLocationInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("iovknlitsbfbtcby")
    public suspend fun locationInfo(argument: List<suspend SkuLocationInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SkuLocationInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yqgqcpbaeyawfonu")
    public suspend fun locationInfo(vararg argument: suspend SkuLocationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SkuLocationInfoArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param argument
     */
    @JvmName("uryhbnawiklwqfkj")
    public suspend fun locationInfo(argument: suspend SkuLocationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SkuLocationInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.locationInfo = mapped
    }

    /**
     * @param values
     */
    @JvmName("mnenudesakhhtvfq")
    public suspend fun locationInfo(vararg values: SkuLocationInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locationInfo = mapped
    }

    /**
     * @param value
     */
    @JvmName("isrcejxiddbltlpv")
    public suspend fun locations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param values
     */
    @JvmName("edcgpjgjbeyuegec")
    public suspend fun locations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.locations = mapped
    }

    /**
     * @param value
     */
    @JvmName("pjppcvidhjxjcpwt")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("skuypvabqsqvwnyk")
    public suspend fun requiredFeatures(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param values
     */
    @JvmName("ewljoulfvgipimcv")
    public suspend fun requiredFeatures(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredFeatures = mapped
    }

    /**
     * @param value
     */
    @JvmName("cknclwulfmtijyyk")
    public suspend fun requiredQuotaIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiredQuotaIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("qauoivjjmfliowqh")
    public suspend fun requiredQuotaIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requiredQuotaIds = mapped
    }

    /**
     * @param value
     */
    @JvmName("jcruhctshejebnyg")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value
     */
    @JvmName("twdsqydpvbpfoyao")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuSettingArgs = SkuSettingArgs(
        capabilities = capabilities,
        capacity = capacity,
        costs = costs,
        family = family,
        kind = kind,
        locationInfo = locationInfo,
        locations = locations,
        name = name ?: throw PulumiNullFieldException("name"),
        requiredFeatures = requiredFeatures,
        requiredQuotaIds = requiredQuotaIds,
        size = size,
        tier = tier,
    )
}
