@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property canary
 * @property expeditedRollout
 * @property highTraffic
 * @property lowTraffic
 * @property mediumTraffic
 * @property providerRegistration
 * @property resourceTypeRegistrations
 * @property restOfTheWorldGroupOne
 * @property restOfTheWorldGroupTwo
 */
public data class DefaultRolloutPropertiesResponseSpecification(
    public val canary: DefaultRolloutSpecificationResponseCanary? = null,
    public val expeditedRollout: DefaultRolloutSpecificationResponseExpeditedRollout? = null,
    public val highTraffic: DefaultRolloutSpecificationResponseHighTraffic? = null,
    public val lowTraffic: DefaultRolloutSpecificationResponseLowTraffic? = null,
    public val mediumTraffic: DefaultRolloutSpecificationResponseMediumTraffic? = null,
    public val providerRegistration: DefaultRolloutSpecificationResponseProviderRegistration? = null,
    public val resourceTypeRegistrations: List<ResourceTypeRegistrationResponse>? = null,
    public val restOfTheWorldGroupOne: DefaultRolloutSpecificationResponseRestOfTheWorldGroupOne? =
        null,
    public val restOfTheWorldGroupTwo: DefaultRolloutSpecificationResponseRestOfTheWorldGroupTwo? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.DefaultRolloutPropertiesResponseSpecification): DefaultRolloutPropertiesResponseSpecification =
            DefaultRolloutPropertiesResponseSpecification(
                canary = javaType.canary().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutSpecificationResponseCanary.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                expeditedRollout = javaType.expeditedRollout().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutSpecificationResponseExpeditedRollout.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                highTraffic = javaType.highTraffic().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutSpecificationResponseHighTraffic.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lowTraffic = javaType.lowTraffic().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutSpecificationResponseLowTraffic.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                mediumTraffic = javaType.mediumTraffic().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutSpecificationResponseMediumTraffic.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                providerRegistration = javaType.providerRegistration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutSpecificationResponseProviderRegistration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                resourceTypeRegistrations = javaType.resourceTypeRegistrations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.ResourceTypeRegistrationResponse.Companion.toKotlin(args0)
                    })
                }),
                restOfTheWorldGroupOne = javaType.restOfTheWorldGroupOne().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutSpecificationResponseRestOfTheWorldGroupOne.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                restOfTheWorldGroupTwo = javaType.restOfTheWorldGroupTwo().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutSpecificationResponseRestOfTheWorldGroupTwo.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
