@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the rollout.
 * @property provisioningState The provisioned state of the resource.
 * @property specification
 * @property status
 */
public data class DefaultRolloutResponseProperties(
    public val provisioningState: String? = null,
    public val specification: DefaultRolloutPropertiesResponseSpecification? = null,
    public val status: DefaultRolloutPropertiesResponseStatus? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.DefaultRolloutResponseProperties): DefaultRolloutResponseProperties = DefaultRolloutResponseProperties(
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            specification = javaType.specification().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutPropertiesResponseSpecification.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.DefaultRolloutPropertiesResponseStatus.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
