@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property additionalInfo
 * @property code
 * @property details
 * @property message
 * @property target
 */
public data class ExtendedErrorInfoResponse(
    public val additionalInfo: List<TypedErrorInfoResponse>? = null,
    public val code: String? = null,
    public val details: List<ExtendedErrorInfoResponse>? = null,
    public val message: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.ExtendedErrorInfoResponse): ExtendedErrorInfoResponse = ExtendedErrorInfoResponse(
            additionalInfo = javaType.additionalInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.TypedErrorInfoResponse.Companion.toKotlin(args0)
                })
            }),
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ExtendedErrorInfoResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
