@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property includedEvents
 * @property messageScope
 * @property notificationEndpoints
 * @property notificationMode
 * @property provisioningState The provisioned state of the resource.
 */
public data class NotificationRegistrationResponseProperties(
    public val includedEvents: List<String>? = null,
    public val messageScope: String? = null,
    public val notificationEndpoints: List<NotificationEndpointResponse>? = null,
    public val notificationMode: String? = null,
    public val provisioningState: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.NotificationRegistrationResponseProperties): NotificationRegistrationResponseProperties = NotificationRegistrationResponseProperties(
            includedEvents = javaType.includedEvents().map({ args0 -> args0 }),
            messageScope = javaType.messageScope().map({ args0 -> args0 }).orElse(null),
            notificationEndpoints = javaType.notificationEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.NotificationEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            notificationMode = javaType.notificationMode().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
        )
    }
}
