@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property effect
 * @property quotaId
 * @property requiredFeatures
 */
public data class ResourceProviderCapabilitiesResponse(
    public val effect: String,
    public val quotaId: String,
    public val requiredFeatures: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.ResourceProviderCapabilitiesResponse): ResourceProviderCapabilitiesResponse = ResourceProviderCapabilitiesResponse(
            effect = javaType.effect(),
            quotaId = javaType.quotaId(),
            requiredFeatures = javaType.requiredFeatures().map({ args0 -> args0 }),
        )
    }
}
