@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property endpointUri
 * @property extensionCategories
 * @property timeout
 */
public data class ResourceTypeExtensionResponse(
    public val endpointUri: String? = null,
    public val extensionCategories: List<String>? = null,
    public val timeout: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.ResourceTypeExtensionResponse): ResourceTypeExtensionResponse = ResourceTypeExtensionResponse(
            endpointUri = javaType.endpointUri().map({ args0 -> args0 }).orElse(null),
            extensionCategories = javaType.extensionCategories().map({ args0 -> args0 }),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
        )
    }
}
