@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property incidentContactEmail
 * @property incidentRoutingService
 * @property incidentRoutingTeam
 * @property manifestOwners
 * @property resourceAccessPolicy
 * @property resourceAccessRoles
 * @property schemaOwners
 * @property serviceTreeInfos
 */
public data class ResourceTypeRegistrationPropertiesResponseManagement(
    public val incidentContactEmail: String? = null,
    public val incidentRoutingService: String? = null,
    public val incidentRoutingTeam: String? = null,
    public val manifestOwners: List<String>? = null,
    public val resourceAccessPolicy: String? = null,
    public val resourceAccessRoles: List<Any>? = null,
    public val schemaOwners: List<String>? = null,
    public val serviceTreeInfos: List<ServiceTreeInfoResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.ResourceTypeRegistrationPropertiesResponseManagement): ResourceTypeRegistrationPropertiesResponseManagement =
            ResourceTypeRegistrationPropertiesResponseManagement(
                incidentContactEmail = javaType.incidentContactEmail().map({ args0 -> args0 }).orElse(null),
                incidentRoutingService = javaType.incidentRoutingService().map({ args0 -> args0 }).orElse(null),
                incidentRoutingTeam = javaType.incidentRoutingTeam().map({ args0 -> args0 }).orElse(null),
                manifestOwners = javaType.manifestOwners().map({ args0 -> args0 }),
                resourceAccessPolicy = javaType.resourceAccessPolicy().map({ args0 -> args0 }).orElse(null),
                resourceAccessRoles = javaType.resourceAccessRoles().map({ args0 -> args0 }),
                schemaOwners = javaType.schemaOwners().map({ args0 -> args0 }),
                serviceTreeInfos = javaType.serviceTreeInfos().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.providerhub.kotlin.outputs.ServiceTreeInfoResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
