@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property extendedLocations
 * @property location
 * @property type
 * @property zoneDetails
 * @property zones
 */
public data class SkuLocationInfoResponse(
    public val extendedLocations: List<String>? = null,
    public val location: String,
    public val type: String? = null,
    public val zoneDetails: List<SkuZoneDetailResponse>? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.SkuLocationInfoResponse): SkuLocationInfoResponse = SkuLocationInfoResponse(
            extendedLocations = javaType.extendedLocations().map({ args0 -> args0 }),
            location = javaType.location(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            zoneDetails = javaType.zoneDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.SkuZoneDetailResponse.Companion.toKotlin(args0)
                })
            }),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
