@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property capabilities
 * @property capacity
 * @property costs
 * @property family
 * @property kind
 * @property locationInfo
 * @property locations
 * @property name
 * @property requiredFeatures
 * @property requiredQuotaIds
 * @property size
 * @property tier
 */
public data class SkuSettingResponse(
    public val capabilities: List<SkuCapabilityResponse>? = null,
    public val capacity: SkuSettingResponseCapacity? = null,
    public val costs: List<SkuCostResponse>? = null,
    public val family: String? = null,
    public val kind: String? = null,
    public val locationInfo: List<SkuLocationInfoResponse>? = null,
    public val locations: List<String>? = null,
    public val name: String,
    public val requiredFeatures: List<String>? = null,
    public val requiredQuotaIds: List<String>? = null,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.SkuSettingResponse): SkuSettingResponse = SkuSettingResponse(
            capabilities = javaType.capabilities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.SkuCapabilityResponse.Companion.toKotlin(args0)
                })
            }),
            capacity = javaType.capacity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.SkuSettingResponseCapacity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            costs = javaType.costs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.SkuCostResponse.Companion.toKotlin(args0)
                })
            }),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            locationInfo = javaType.locationInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.SkuLocationInfoResponse.Companion.toKotlin(args0)
                })
            }),
            locations = javaType.locations().map({ args0 -> args0 }),
            name = javaType.name(),
            requiredFeatures = javaType.requiredFeatures().map({ args0 -> args0 }),
            requiredQuotaIds = javaType.requiredQuotaIds().map({ args0 -> args0 }),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
