@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.providerhub.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action
 * @property metrics
 * @property requiredFeatures
 */
public data class ThrottlingRuleResponse(
    public val action: String,
    public val metrics: List<ThrottlingMetricResponse>,
    public val requiredFeatures: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.providerhub.outputs.ThrottlingRuleResponse): ThrottlingRuleResponse = ThrottlingRuleResponse(
            action = javaType.action(),
            metrics = javaType.metrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.providerhub.kotlin.outputs.ThrottlingMetricResponse.Companion.toKotlin(args0)
                })
            }),
            requiredFeatures = javaType.requiredFeatures().map({ args0 -> args0 }),
        )
    }
}
