@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin

import com.pulumi.azurenative.purview.PurviewFunctions.getAccountPlain
import com.pulumi.azurenative.purview.PurviewFunctions.getKafkaConfigurationPlain
import com.pulumi.azurenative.purview.PurviewFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.purview.PurviewFunctions.listAccountKeysPlain
import com.pulumi.azurenative.purview.PurviewFunctions.listFeatureAccountPlain
import com.pulumi.azurenative.purview.PurviewFunctions.listFeatureSubscriptionPlain
import com.pulumi.azurenative.purview.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.purview.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.purview.kotlin.inputs.GetKafkaConfigurationPlainArgs
import com.pulumi.azurenative.purview.kotlin.inputs.GetKafkaConfigurationPlainArgsBuilder
import com.pulumi.azurenative.purview.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.purview.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.purview.kotlin.inputs.ListAccountKeysPlainArgs
import com.pulumi.azurenative.purview.kotlin.inputs.ListAccountKeysPlainArgsBuilder
import com.pulumi.azurenative.purview.kotlin.inputs.ListFeatureAccountPlainArgs
import com.pulumi.azurenative.purview.kotlin.inputs.ListFeatureAccountPlainArgsBuilder
import com.pulumi.azurenative.purview.kotlin.inputs.ListFeatureSubscriptionPlainArgs
import com.pulumi.azurenative.purview.kotlin.inputs.ListFeatureSubscriptionPlainArgsBuilder
import com.pulumi.azurenative.purview.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.purview.kotlin.outputs.GetKafkaConfigurationResult
import com.pulumi.azurenative.purview.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.purview.kotlin.outputs.ListAccountKeysResult
import com.pulumi.azurenative.purview.kotlin.outputs.ListFeatureAccountResult
import com.pulumi.azurenative.purview.kotlin.outputs.ListFeatureSubscriptionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.purview.kotlin.outputs.GetAccountResult.Companion.toKotlin as getAccountResultToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.GetKafkaConfigurationResult.Companion.toKotlin as getKafkaConfigurationResultToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.ListAccountKeysResult.Companion.toKotlin as listAccountKeysResultToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.ListFeatureAccountResult.Companion.toKotlin as listFeatureAccountResultToKotlin
import com.pulumi.azurenative.purview.kotlin.outputs.ListFeatureSubscriptionResult.Companion.toKotlin as listFeatureSubscriptionResultToKotlin

public object PurviewFunctions {
    /**
     * Get an account
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2020-12-01-preview, 2021-07-01, 2023-05-01-preview.
     * @param argument null
     * @return Account resource
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param accountName The name of the account.
     * @param resourceGroupName The resource group name.
     * @return Account resource
     */
    public suspend fun getAccount(accountName: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return getAccountResultToKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;purview&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return Account resource
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit): GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccountResultToKotlin(getAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the kafka configuration for the account
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2023-05-01-preview.
     * @param argument null
     * @return The configuration of the event streaming service resource attached to the Purview account for kafka notifications.
     */
    public suspend fun getKafkaConfiguration(argument: GetKafkaConfigurationPlainArgs): GetKafkaConfigurationResult =
        getKafkaConfigurationResultToKotlin(getKafkaConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getKafkaConfiguration].
     * @param accountName The name of the account.
     * @param kafkaConfigurationName Name of kafka configuration.
     * @param resourceGroupName The resource group name.
     * @return The configuration of the event streaming service resource attached to the Purview account for kafka notifications.
     */
    public suspend fun getKafkaConfiguration(
        accountName: String,
        kafkaConfigurationName: String,
        resourceGroupName: String,
    ): GetKafkaConfigurationResult {
        val argument = GetKafkaConfigurationPlainArgs(
            accountName = accountName,
            kafkaConfigurationName = kafkaConfigurationName,
            resourceGroupName = resourceGroupName,
        )
        return getKafkaConfigurationResultToKotlin(getKafkaConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getKafkaConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;purview&#46;kotlin&#46;inputs&#46;GetKafkaConfigurationPlainArgs].
     * @return The configuration of the event streaming service resource attached to the Purview account for kafka notifications.
     */
    public suspend fun getKafkaConfiguration(argument: suspend GetKafkaConfigurationPlainArgsBuilder.() -> Unit): GetKafkaConfigurationResult {
        val builder = GetKafkaConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKafkaConfigurationResultToKotlin(getKafkaConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a private endpoint connection
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2021-07-01, 2023-05-01-preview.
     * @param argument null
     * @return A private endpoint connection class.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param accountName The name of the account.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param resourceGroupName The resource group name.
     * @return A private endpoint connection class.
     */
    public suspend fun getPrivateEndpointConnection(
        accountName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;purview&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection class.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * List the authorization keys associated with this account.
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2020-12-01-preview, 2021-07-01, 2023-05-01-preview.
     * @param argument null
     * @return The Account access keys.
     */
    public suspend fun listAccountKeys(argument: ListAccountKeysPlainArgs): ListAccountKeysResult =
        listAccountKeysResultToKotlin(listAccountKeysPlain(argument.toJava()).await())

    /**
     * @see [listAccountKeys].
     * @param accountName The name of the account.
     * @param resourceGroupName The resource group name.
     * @return The Account access keys.
     */
    public suspend fun listAccountKeys(accountName: String, resourceGroupName: String): ListAccountKeysResult {
        val argument = ListAccountKeysPlainArgs(
            accountName = accountName,
            resourceGroupName = resourceGroupName,
        )
        return listAccountKeysResultToKotlin(listAccountKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listAccountKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;purview&#46;kotlin&#46;inputs&#46;ListAccountKeysPlainArgs].
     * @return The Account access keys.
     */
    public suspend fun listAccountKeys(argument: suspend ListAccountKeysPlainArgsBuilder.() -> Unit): ListAccountKeysResult {
        val builder = ListAccountKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listAccountKeysResultToKotlin(listAccountKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets details from a list of feature names.
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2023-05-01-preview.
     * @param argument null
     * @return List of features with enabled status
     */
    public suspend fun listFeatureAccount(argument: ListFeatureAccountPlainArgs): ListFeatureAccountResult =
        listFeatureAccountResultToKotlin(listFeatureAccountPlain(argument.toJava()).await())

    /**
     * @see [listFeatureAccount].
     * @param accountName The name of the account.
     * @param features Set of features
     * @param resourceGroupName The resource group name.
     * @return List of features with enabled status
     */
    public suspend fun listFeatureAccount(
        accountName: String,
        features: List<String>? = null,
        resourceGroupName: String,
    ): ListFeatureAccountResult {
        val argument = ListFeatureAccountPlainArgs(
            accountName = accountName,
            features = features,
            resourceGroupName = resourceGroupName,
        )
        return listFeatureAccountResultToKotlin(listFeatureAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [listFeatureAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;purview&#46;kotlin&#46;inputs&#46;ListFeatureAccountPlainArgs].
     * @return List of features with enabled status
     */
    public suspend fun listFeatureAccount(argument: suspend ListFeatureAccountPlainArgsBuilder.() -> Unit): ListFeatureAccountResult {
        val builder = ListFeatureAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listFeatureAccountResultToKotlin(listFeatureAccountPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets details from a list of feature names.
     * Azure REST API version: 2021-12-01.
     * Other available API versions: 2023-05-01-preview.
     * @param argument null
     * @return List of features with enabled status
     */
    public suspend fun listFeatureSubscription(argument: ListFeatureSubscriptionPlainArgs): ListFeatureSubscriptionResult =
        listFeatureSubscriptionResultToKotlin(listFeatureSubscriptionPlain(argument.toJava()).await())

    /**
     * @see [listFeatureSubscription].
     * @param features Set of features
     * @param locations Location of feature.
     * @return List of features with enabled status
     */
    public suspend fun listFeatureSubscription(features: List<String>? = null, locations: String): ListFeatureSubscriptionResult {
        val argument = ListFeatureSubscriptionPlainArgs(
            features = features,
            locations = locations,
        )
        return listFeatureSubscriptionResultToKotlin(listFeatureSubscriptionPlain(argument.toJava()).await())
    }

    /**
     * @see [listFeatureSubscription].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;purview&#46;kotlin&#46;inputs&#46;ListFeatureSubscriptionPlainArgs].
     * @return List of features with enabled status
     */
    public suspend fun listFeatureSubscription(argument: suspend ListFeatureSubscriptionPlainArgsBuilder.() -> Unit): ListFeatureSubscriptionResult {
        val builder = ListFeatureSubscriptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listFeatureSubscriptionResultToKotlin(listFeatureSubscriptionPlain(builtArgument.toJava()).await())
    }
}
