@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.inputs

import com.pulumi.azurenative.purview.inputs.ListFeatureAccountPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the account.
 * @property features Set of features
 * @property resourceGroupName The resource group name.
 */
public data class ListFeatureAccountPlainArgs(
    public val accountName: String,
    public val features: List<String>? = null,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.purview.inputs.ListFeatureAccountPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.purview.inputs.ListFeatureAccountPlainArgs =
        com.pulumi.azurenative.purview.inputs.ListFeatureAccountPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .features(features?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListFeatureAccountPlainArgs].
 */
@PulumiTagMarker
public class ListFeatureAccountPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var features: List<String>? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the account.
     */
    @JvmName("sggtbbklnqhskvqv")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Set of features
     */
    @JvmName("aujqffmifvqohsts")
    public suspend fun features(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.features = mapped
    }

    /**
     * @param values Set of features
     */
    @JvmName("eyqbgcmsytqgwids")
    public suspend fun features(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.features = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("ocvdkpmffdjptkbw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListFeatureAccountPlainArgs = ListFeatureAccountPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        features = features,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
