@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The URIs that are the public endpoints of the account.
 * @property catalog Gets the catalog endpoint.
 * @property guardian Gets the guardian endpoint.
 * @property scan Gets the scan endpoint.
 */
public data class AccountPropertiesResponseEndpoints(
    public val catalog: String,
    public val guardian: String,
    public val scan: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.AccountPropertiesResponseEndpoints): AccountPropertiesResponseEndpoints = AccountPropertiesResponseEndpoints(
            catalog = javaType.catalog(),
            guardian = javaType.guardian(),
            scan = javaType.scan(),
        )
    }
}
