@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Gets or sets the Sku.
 * @property capacity Gets or sets the sku capacity.
 * @property name Gets or sets the sku name.
 */
public data class AccountResponseSku(
    public val capacity: Int? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.AccountResponseSku): AccountResponseSku = AccountResponseSku(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
