@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Credentials to access the event streaming service attached to the purview account.
 * @property identityId Identity identifier for UserAssign type.
 * @property type Identity Type.
 */
public data class CredentialsResponse(
    public val identityId: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.CredentialsResponse): CredentialsResponse = CredentialsResponse(
            identityId = javaType.identityId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
