@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Default error model
 * @property code Gets or sets the code.
 * @property details Gets or sets the details.
 * @property message Gets or sets the messages.
 * @property target Gets or sets the target.
 */
public data class ErrorModelResponse(
    public val code: String,
    public val details: List<ErrorModelResponse>,
    public val message: String,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.ErrorModelResponse): ErrorModelResponse = ErrorModelResponse(
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.purview.kotlin.outputs.ErrorModelResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
            target = javaType.target(),
        )
    }
}
