@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.purview.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Account resource
 * @property accountStatus Gets or sets the status of the account.
 * @property cloudConnectors Cloud connectors.
 * External cloud identifier used as part of scanning configuration.
 * @property createdAt Gets the time at which the entity was created.
 * @property createdBy Gets the creator of the entity.
 * @property createdByObjectId Gets the creators of the entity's object id.
 * @property endpoints The URIs that are the public endpoints of the account.
 * @property friendlyName Gets or sets the friendly name.
 * @property id Gets or sets the identifier.
 * @property identity Identity Info on the tracked resource
 * @property location Gets or sets the location.
 * @property managedEventHubState  Gets or sets the state of managed eventhub. If enabled managed eventhub will be created, if disabled the managed eventhub will be removed.
 * @property managedResourceGroupName Gets or sets the managed resource group name
 * @property managedResources Gets the resource identifiers of the managed resources.
 * @property managedResourcesPublicNetworkAccess Gets or sets the public network access for managed resources.
 * @property name Gets or sets the name.
 * @property privateEndpointConnections Gets the private endpoint connections information.
 * @property provisioningState Gets or sets the state of the provisioning.
 * @property publicNetworkAccess Gets or sets the public network access.
 * @property sku Gets or sets the Sku.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Tags on the azure resource.
 * @property type Gets or sets the type.
 */
public data class GetAccountResult(
    public val accountStatus: AccountPropertiesResponseAccountStatus,
    public val cloudConnectors: CloudConnectorsResponse? = null,
    public val createdAt: String,
    public val createdBy: String,
    public val createdByObjectId: String,
    public val endpoints: AccountPropertiesResponseEndpoints,
    public val friendlyName: String,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String? = null,
    public val managedEventHubState: String? = null,
    public val managedResourceGroupName: String? = null,
    public val managedResources: AccountPropertiesResponseManagedResources,
    public val managedResourcesPublicNetworkAccess: String? = null,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val sku: AccountResponseSku,
    public val systemData: TrackedResourceResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.purview.outputs.GetAccountResult): GetAccountResult = GetAccountResult(
            accountStatus = javaType.accountStatus().let({ args0 ->
                com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseAccountStatus.Companion.toKotlin(args0)
            }),
            cloudConnectors = javaType.cloudConnectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.purview.kotlin.outputs.CloudConnectorsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdAt = javaType.createdAt(),
            createdBy = javaType.createdBy(),
            createdByObjectId = javaType.createdByObjectId(),
            endpoints = javaType.endpoints().let({ args0 ->
                com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseEndpoints.Companion.toKotlin(args0)
            }),
            friendlyName = javaType.friendlyName(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.purview.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedEventHubState = javaType.managedEventHubState().map({ args0 -> args0 }).orElse(null),
            managedResourceGroupName = javaType.managedResourceGroupName().map({ args0 -> args0 }).orElse(null),
            managedResources = javaType.managedResources().let({ args0 ->
                com.pulumi.azurenative.purview.kotlin.outputs.AccountPropertiesResponseManagedResources.Companion.toKotlin(args0)
            }),
            managedResourcesPublicNetworkAccess = javaType.managedResourcesPublicNetworkAccess().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.purview.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.purview.kotlin.outputs.AccountResponseSku.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.purview.kotlin.outputs.TrackedResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
