@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin

import com.pulumi.azurenative.quantum.QuantumFunctions.getWorkspacePlain
import com.pulumi.azurenative.quantum.QuantumFunctions.listWorkspaceKeysPlain
import com.pulumi.azurenative.quantum.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.quantum.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.quantum.kotlin.inputs.ListWorkspaceKeysPlainArgs
import com.pulumi.azurenative.quantum.kotlin.inputs.ListWorkspaceKeysPlainArgsBuilder
import com.pulumi.azurenative.quantum.kotlin.outputs.GetWorkspaceResult
import com.pulumi.azurenative.quantum.kotlin.outputs.ListWorkspaceKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.quantum.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin
import com.pulumi.azurenative.quantum.kotlin.outputs.ListWorkspaceKeysResult.Companion.toKotlin as listWorkspaceKeysResultToKotlin

public object QuantumFunctions {
    /**
     * Returns the Workspace resource associated with the given name.
     * Azure REST API version: 2022-01-10-preview.
     * Other available API versions: 2023-11-13-preview.
     * @param argument null
     * @return The resource proxy definition object for quantum workspace.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group.
     * @param workspaceName The name of the quantum workspace resource.
     * @return The resource proxy definition object for quantum workspace.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String): GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;quantum&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return The resource proxy definition object for quantum workspace.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit): GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Get the keys to use with the Quantum APIs. A key is used to authenticate and authorize access to the Quantum REST APIs. Only one key is needed at a time; two are given to provide seamless key regeneration.
     * Azure REST API version: 2023-11-13-preview.
     * @param argument null
     * @return Result of list Api keys and connection strings.
     */
    public suspend fun listWorkspaceKeys(argument: ListWorkspaceKeysPlainArgs): ListWorkspaceKeysResult =
        listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(argument.toJava()).await())

    /**
     * @see [listWorkspaceKeys].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the quantum workspace resource.
     * @return Result of list Api keys and connection strings.
     */
    public suspend fun listWorkspaceKeys(resourceGroupName: String, workspaceName: String): ListWorkspaceKeysResult {
        val argument = ListWorkspaceKeysPlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listWorkspaceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;quantum&#46;kotlin&#46;inputs&#46;ListWorkspaceKeysPlainArgs].
     * @return Result of list Api keys and connection strings.
     */
    public suspend fun listWorkspaceKeys(argument: suspend ListWorkspaceKeysPlainArgsBuilder.() -> Unit): ListWorkspaceKeysResult {
        val builder = ListWorkspaceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listWorkspaceKeysResultToKotlin(listWorkspaceKeysPlain(builtArgument.toJava()).await())
    }
}
