@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin.inputs

import com.pulumi.azurenative.quantum.inputs.QuantumWorkspaceIdentityArgs.builder
import com.pulumi.azurenative.quantum.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Managed Identity information.
 * @property type The identity type.
 */
public data class QuantumWorkspaceIdentityArgs(
    public val type: Output<Either<String, ResourceIdentityType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.quantum.inputs.QuantumWorkspaceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.quantum.inputs.QuantumWorkspaceIdentityArgs =
        com.pulumi.azurenative.quantum.inputs.QuantumWorkspaceIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [QuantumWorkspaceIdentityArgs].
 */
@PulumiTagMarker
public class QuantumWorkspaceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, ResourceIdentityType>>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("tcbghqmdobqkmgvi")
    public suspend fun type(`value`: Output<Either<String, ResourceIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("ofpcplsfnvijulvg")
    public suspend fun type(`value`: Either<String, ResourceIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("fdfyipusjpqcestr")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("xojporlctaxyubap")
    public fun type(`value`: ResourceIdentityType) {
        val toBeMapped = Either.ofRight<String, ResourceIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): QuantumWorkspaceIdentityArgs = QuantumWorkspaceIdentityArgs(
        type = type,
    )
}
