@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure quantum workspace Api key details.
 * @property createdAt The creation time of the api key.
 * @property key The Api key.
 */
public data class ApiKeyResponse(
    public val createdAt: String? = null,
    public val key: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.quantum.outputs.ApiKeyResponse): ApiKeyResponse = ApiKeyResponse(
            createdAt = javaType.createdAt().map({ args0 -> args0 }).orElse(null),
            key = javaType.key(),
        )
    }
}
