@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The resource proxy definition object for quantum workspace.
 * @property endpointUri The URI of the workspace endpoint.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Managed Identity information.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property providers List of Providers selected for this Workspace
 * @property provisioningState Provisioning status field
 * @property storageAccount ARM Resource Id of the storage account associated with this workspace.
 * @property systemData System metadata
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property usable Whether the current workspace is ready to accept Jobs.
 */
public data class GetWorkspaceResult(
    public val endpointUri: String,
    public val id: String,
    public val identity: QuantumWorkspaceResponseIdentity? = null,
    public val location: String,
    public val name: String,
    public val providers: List<ProviderResponse>? = null,
    public val provisioningState: String,
    public val storageAccount: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val usable: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.quantum.outputs.GetWorkspaceResult): GetWorkspaceResult = GetWorkspaceResult(
            endpointUri = javaType.endpointUri(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.quantum.kotlin.outputs.QuantumWorkspaceResponseIdentity.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            providers = javaType.providers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.quantum.kotlin.outputs.ProviderResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            storageAccount = javaType.storageAccount().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.quantum.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            usable = javaType.usable(),
        )
    }
}
