@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quantum.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about a Provider. A Provider is an entity that offers Targets to run Azure Quantum Jobs.
 * @property applicationName The provider's marketplace application display name.
 * @property instanceUri A Uri identifying the specific instance of this provider.
 * @property providerId Unique id of this provider.
 * @property providerSku The sku associated with pricing information for this provider.
 * @property provisioningState Provisioning status field
 * @property resourceUsageId Id to track resource usage for the provider.
 */
public data class ProviderResponse(
    public val applicationName: String? = null,
    public val instanceUri: String? = null,
    public val providerId: String? = null,
    public val providerSku: String? = null,
    public val provisioningState: String? = null,
    public val resourceUsageId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.quantum.outputs.ProviderResponse): ProviderResponse = ProviderResponse(
            applicationName = javaType.applicationName().map({ args0 -> args0 }).orElse(null),
            instanceUri = javaType.instanceUri().map({ args0 -> args0 }).orElse(null),
            providerId = javaType.providerId().map({ args0 -> args0 }).orElse(null),
            providerSku = javaType.providerSku().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            resourceUsageId = javaType.resourceUsageId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
