@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin

import com.pulumi.azurenative.quota.GroupQuotaArgs.builder
import com.pulumi.azurenative.quota.kotlin.inputs.GroupQuotasEntityBaseArgs
import com.pulumi.azurenative.quota.kotlin.inputs.GroupQuotasEntityBaseArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### GroupQuotas_Put_Request_ForCompute
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var groupQuota = new AzureNative.Quota.GroupQuota("groupQuota", new()
 *     {
 *         GroupQuotaName = "groupquota1",
 *         ManagementGroupId = "E7EC67B3-7657-4966-BFFC-41EFD36BAA09",
 *         Properties = new AzureNative.Quota.Inputs.GroupQuotasEntityBaseArgs
 *         {
 *             AdditionalAttributes = new AzureNative.Quota.Inputs.AdditionalAttributesArgs
 *             {
 *                 Environment = "Production",
 *                 GroupId = new AzureNative.Quota.Inputs.GroupingIdArgs
 *                 {
 *                     GroupingIdType = AzureNative.Quota.GroupingIdType.ServiceTreeId,
 *                     Value = "yourServiceTreeIdHere",
 *                 },
 *             },
 *             DisplayName = "GroupQuota1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/quota/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quota.NewGroupQuota(ctx, "groupQuota", &quota.GroupQuotaArgs{
 * 			GroupQuotaName:    pulumi.String("groupquota1"),
 * 			ManagementGroupId: pulumi.String("E7EC67B3-7657-4966-BFFC-41EFD36BAA09"),
 * 			Properties: &quota.GroupQuotasEntityBaseArgs{
 * 				AdditionalAttributes: &quota.AdditionalAttributesArgs{
 * 					Environment: pulumi.Any("Production"),
 * 					GroupId: &quota.GroupingIdArgs{
 * 						GroupingIdType: pulumi.String(quota.GroupingIdTypeServiceTreeId),
 * 						Value:          pulumi.String("yourServiceTreeIdHere"),
 * 					},
 * 				},
 * 				DisplayName: pulumi.String("GroupQuota1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.quota.GroupQuota;
 * import com.pulumi.azurenative.quota.GroupQuotaArgs;
 * import com.pulumi.azurenative.quota.inputs.GroupQuotasEntityBaseArgs;
 * import com.pulumi.azurenative.quota.inputs.AdditionalAttributesArgs;
 * import com.pulumi.azurenative.quota.inputs.GroupingIdArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var groupQuota = new GroupQuota("groupQuota", GroupQuotaArgs.builder()
 *             .groupQuotaName("groupquota1")
 *             .managementGroupId("E7EC67B3-7657-4966-BFFC-41EFD36BAA09")
 *             .properties(GroupQuotasEntityBaseArgs.builder()
 *                 .additionalAttributes(AdditionalAttributesArgs.builder()
 *                     .environment("Production")
 *                     .groupId(GroupingIdArgs.builder()
 *                         .groupingIdType("ServiceTreeId")
 *                         .value("yourServiceTreeIdHere")
 *                         .build())
 *                     .build())
 *                 .displayName("GroupQuota1")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:quota:GroupQuota groupquota1 /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Quota/groupQuotas/{groupQuotaName}
 * ```
 * @property groupQuotaName The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
 * @property managementGroupId Management Group Id.
 * @property properties Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
 */
public data class GroupQuotaArgs(
    public val groupQuotaName: Output<String>? = null,
    public val managementGroupId: Output<String>? = null,
    public val properties: Output<GroupQuotasEntityBaseArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.quota.GroupQuotaArgs> {
    override fun toJava(): com.pulumi.azurenative.quota.GroupQuotaArgs =
        com.pulumi.azurenative.quota.GroupQuotaArgs.builder()
            .groupQuotaName(groupQuotaName?.applyValue({ args0 -> args0 }))
            .managementGroupId(managementGroupId?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GroupQuotaArgs].
 */
@PulumiTagMarker
public class GroupQuotaArgsBuilder internal constructor() {
    private var groupQuotaName: Output<String>? = null

    private var managementGroupId: Output<String>? = null

    private var properties: Output<GroupQuotasEntityBaseArgs>? = null

    /**
     * @param value The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
     */
    @JvmName("bonpnyrpdpbdfkso")
    public suspend fun groupQuotaName(`value`: Output<String>) {
        this.groupQuotaName = value
    }

    /**
     * @param value Management Group Id.
     */
    @JvmName("avqcxcouoqtmwolh")
    public suspend fun managementGroupId(`value`: Output<String>) {
        this.managementGroupId = value
    }

    /**
     * @param value Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
     */
    @JvmName("nqhfvgqbabkswjho")
    public suspend fun properties(`value`: Output<GroupQuotasEntityBaseArgs>) {
        this.properties = value
    }

    /**
     * @param value The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
     */
    @JvmName("fqvwunqyyxcnlhui")
    public suspend fun groupQuotaName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupQuotaName = mapped
    }

    /**
     * @param value Management Group Id.
     */
    @JvmName("bujcgcvedcyunoag")
    public suspend fun managementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupId = mapped
    }

    /**
     * @param value Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
     */
    @JvmName("snxgwtbjrirumstv")
    public suspend fun properties(`value`: GroupQuotasEntityBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
     */
    @JvmName("lahpbmudafcpkpmc")
    public suspend fun properties(argument: suspend GroupQuotasEntityBaseArgsBuilder.() -> Unit) {
        val toBeMapped = GroupQuotasEntityBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): GroupQuotaArgs = GroupQuotaArgs(
        groupQuotaName = groupQuotaName,
        managementGroupId = managementGroupId,
        properties = properties,
    )
}
