@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.inputs

import com.pulumi.azurenative.quota.inputs.GetGroupQuotaSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupQuotaName The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
 * @property managementGroupId Management Group Id.
 */
public data class GetGroupQuotaSubscriptionPlainArgs(
    public val groupQuotaName: String,
    public val managementGroupId: String,
) : ConvertibleToJava<com.pulumi.azurenative.quota.inputs.GetGroupQuotaSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.quota.inputs.GetGroupQuotaSubscriptionPlainArgs =
        com.pulumi.azurenative.quota.inputs.GetGroupQuotaSubscriptionPlainArgs.builder()
            .groupQuotaName(groupQuotaName.let({ args0 -> args0 }))
            .managementGroupId(managementGroupId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupQuotaSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetGroupQuotaSubscriptionPlainArgsBuilder internal constructor() {
    private var groupQuotaName: String? = null

    private var managementGroupId: String? = null

    /**
     * @param value The GroupQuota name. The name should be unique for the provided context tenantId/MgId.
     */
    @JvmName("tlsmogkpwxfahyxk")
    public suspend fun groupQuotaName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.groupQuotaName = mapped
    }

    /**
     * @param value Management Group Id.
     */
    @JvmName("wlbcaugujqmvtqlk")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    internal fun build(): GetGroupQuotaSubscriptionPlainArgs = GetGroupQuotaSubscriptionPlainArgs(
        groupQuotaName = groupQuotaName ?: throw PulumiNullFieldException("groupQuotaName"),
        managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
    )
}
