@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.quota.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties and filters for ShareQuota. The request parameter is optional, if there are no filters specified.
 * @property additionalAttributes Additional attributes to filter/restrict the subscriptions, which can be added to the subscriptionIds.
 * @property displayName Display name of the GroupQuota entity.
 * @property provisioningState Provisioning state of the operation.
 */
public data class GroupQuotasEntityBaseResponse(
    public val additionalAttributes: AdditionalAttributesResponse? = null,
    public val displayName: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.quota.outputs.GroupQuotasEntityBaseResponse): GroupQuotasEntityBaseResponse = GroupQuotasEntityBaseResponse(
            additionalAttributes = javaType.additionalAttributes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.quota.kotlin.outputs.AdditionalAttributesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
