@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.inputs

import com.pulumi.azurenative.recommendationsservice.inputs.CorsRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * CORS details.
 * @property allowedHeaders The request headers that the origin domain may specify on the CORS request.
 * @property allowedMethods The methods (HTTP request verbs) that the origin domain may use for a CORS request.
 * @property allowedOrigins The origin domains that are permitted to make a request against the service via CORS.
 * @property exposedHeaders The response headers to expose to CORS clients.
 * @property maxAgeInSeconds The number of seconds that the client/browser should cache a preflight response.
 */
public data class CorsRuleArgs(
    public val allowedHeaders: Output<List<String>>? = null,
    public val allowedMethods: Output<List<String>>? = null,
    public val allowedOrigins: Output<List<String>>,
    public val exposedHeaders: Output<List<String>>? = null,
    public val maxAgeInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recommendationsservice.inputs.CorsRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.recommendationsservice.inputs.CorsRuleArgs =
        com.pulumi.azurenative.recommendationsservice.inputs.CorsRuleArgs.builder()
            .allowedHeaders(allowedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedMethods(allowedMethods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrigins(allowedOrigins.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposedHeaders(exposedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAgeInSeconds(maxAgeInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CorsRuleArgs].
 */
@PulumiTagMarker
public class CorsRuleArgsBuilder internal constructor() {
    private var allowedHeaders: Output<List<String>>? = null

    private var allowedMethods: Output<List<String>>? = null

    private var allowedOrigins: Output<List<String>>? = null

    private var exposedHeaders: Output<List<String>>? = null

    private var maxAgeInSeconds: Output<Int>? = null

    /**
     * @param value The request headers that the origin domain may specify on the CORS request.
     */
    @JvmName("lahscwhwwmumwpos")
    public suspend fun allowedHeaders(`value`: Output<List<String>>) {
        this.allowedHeaders = value
    }

    @JvmName("nongtivlmabkixyr")
    public suspend fun allowedHeaders(vararg values: Output<String>) {
        this.allowedHeaders = Output.all(values.asList())
    }

    /**
     * @param values The request headers that the origin domain may specify on the CORS request.
     */
    @JvmName("onpklxnbkxpjsuaq")
    public suspend fun allowedHeaders(values: List<Output<String>>) {
        this.allowedHeaders = Output.all(values)
    }

    /**
     * @param value The methods (HTTP request verbs) that the origin domain may use for a CORS request.
     */
    @JvmName("jklcrbhnqwdhqwmk")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("ekuyqiuyyaktrvpw")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values The methods (HTTP request verbs) that the origin domain may use for a CORS request.
     */
    @JvmName("clcovuqsvgukkpqp")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value The origin domains that are permitted to make a request against the service via CORS.
     */
    @JvmName("btlyouoapkyqjimg")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("bmlmtjnpaebmdohc")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values The origin domains that are permitted to make a request against the service via CORS.
     */
    @JvmName("fljoopaprcmecdog")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value The response headers to expose to CORS clients.
     */
    @JvmName("qfojycnbujvgdmvn")
    public suspend fun exposedHeaders(`value`: Output<List<String>>) {
        this.exposedHeaders = value
    }

    @JvmName("xjviraydcidenxve")
    public suspend fun exposedHeaders(vararg values: Output<String>) {
        this.exposedHeaders = Output.all(values.asList())
    }

    /**
     * @param values The response headers to expose to CORS clients.
     */
    @JvmName("txhsonwyepycfxgc")
    public suspend fun exposedHeaders(values: List<Output<String>>) {
        this.exposedHeaders = Output.all(values)
    }

    /**
     * @param value The number of seconds that the client/browser should cache a preflight response.
     */
    @JvmName("pssdccofosdkvonc")
    public suspend fun maxAgeInSeconds(`value`: Output<Int>) {
        this.maxAgeInSeconds = value
    }

    /**
     * @param value The request headers that the origin domain may specify on the CORS request.
     */
    @JvmName("xtxjpwfgmrtnguqd")
    public suspend fun allowedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param values The request headers that the origin domain may specify on the CORS request.
     */
    @JvmName("njdkpgsjyjkcyxvh")
    public suspend fun allowedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value The methods (HTTP request verbs) that the origin domain may use for a CORS request.
     */
    @JvmName("eqcrcdkcxkuchdqc")
    public suspend fun allowedMethods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values The methods (HTTP request verbs) that the origin domain may use for a CORS request.
     */
    @JvmName("xmriholdwyynivuq")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value The origin domains that are permitted to make a request against the service via CORS.
     */
    @JvmName("atvsttgslkqacxtq")
    public suspend fun allowedOrigins(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values The origin domains that are permitted to make a request against the service via CORS.
     */
    @JvmName("telidpccfjyshvjq")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value The response headers to expose to CORS clients.
     */
    @JvmName("jmctgempyryeyafn")
    public suspend fun exposedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposedHeaders = mapped
    }

    /**
     * @param values The response headers to expose to CORS clients.
     */
    @JvmName("mpfjoegdedquvghc")
    public suspend fun exposedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposedHeaders = mapped
    }

    /**
     * @param value The number of seconds that the client/browser should cache a preflight response.
     */
    @JvmName("yoejgctsixqyumhc")
    public suspend fun maxAgeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAgeInSeconds = mapped
    }

    internal fun build(): CorsRuleArgs = CorsRuleArgs(
        allowedHeaders = allowedHeaders,
        allowedMethods = allowedMethods,
        allowedOrigins = allowedOrigins ?: throw PulumiNullFieldException("allowedOrigins"),
        exposedHeaders = exposedHeaders,
        maxAgeInSeconds = maxAgeInSeconds,
    )
}
