@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recommendationsservice.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Service endpoints authentication details.
 * @property aadTenantID AAD tenant ID.
 * @property principalID AAD principal ID.
 * @property principalType AAD principal type.
 */
public data class EndpointAuthenticationResponse(
    public val aadTenantID: String? = null,
    public val principalID: String? = null,
    public val principalType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.recommendationsservice.outputs.EndpointAuthenticationResponse): EndpointAuthenticationResponse = EndpointAuthenticationResponse(
            aadTenantID = javaType.aadTenantID().map({ args0 -> args0 }).orElse(null),
            principalID = javaType.principalID().map({ args0 -> args0 }).orElse(null),
            principalType = javaType.principalType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
