@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ProtectionContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Base class for container with backup items. Containers with specific workloads are derived from this class.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01, 2024-04-01, 2024-04-30-preview.
 * ## Example Usage
 * ### RegisterAzure Storage ProtectionContainers
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionContainer = new AzureNative.RecoveryServices.ProtectionContainer("protectionContainer", new()
 *     {
 *         ContainerName = "StorageContainer;Storage;SwaggerTestRg;swaggertestsa",
 *         FabricName = "Azure",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureStorageContainerArgs
 *         {
 *             AcquireStorageAccountLock = AzureNative.RecoveryServices.AcquireStorageAccountLock.Acquire,
 *             BackupManagementType = AzureNative.RecoveryServices.BackupManagementType.AzureStorage,
 *             ContainerType = "StorageContainer",
 *             FriendlyName = "swaggertestsa",
 *             SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/SwaggerTestRg/providers/Microsoft.Storage/storageAccounts/swaggertestsa",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "swaggertestvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionContainer(ctx, "protectionContainer", &recoveryservices.ProtectionContainerArgs{
 * 			ContainerName: pulumi.String("StorageContainer;Storage;SwaggerTestRg;swaggertestsa"),
 * 			FabricName:    pulumi.String("Azure"),
 * 			Properties: recoveryservices.AzureStorageContainer{
 * 				AcquireStorageAccountLock: recoveryservices.AcquireStorageAccountLockAcquire,
 * 				BackupManagementType:      recoveryservices.BackupManagementTypeAzureStorage,
 * 				ContainerType:             "StorageContainer",
 * 				FriendlyName:              "swaggertestsa",
 * 				SourceResourceId:          "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/SwaggerTestRg/providers/Microsoft.Storage/storageAccounts/swaggertestsa",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("swaggertestvault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionContainer;
 * import com.pulumi.azurenative.recoveryservices.ProtectionContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionContainer = new ProtectionContainer("protectionContainer", ProtectionContainerArgs.builder()
 *             .containerName("StorageContainer;Storage;SwaggerTestRg;swaggertestsa")
 *             .fabricName("Azure")
 *             .properties(AzureStorageContainerArgs.builder()
 *                 .acquireStorageAccountLock("Acquire")
 *                 .backupManagementType("AzureStorage")
 *                 .containerType("StorageContainer")
 *                 .friendlyName("swaggertestsa")
 *                 .sourceResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/SwaggerTestRg/providers/Microsoft.Storage/storageAccounts/swaggertestsa")
 *                 .build())
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("swaggertestvault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ProtectionContainer StorageContainer;Storage;SwaggerTestRg;swaggertestsa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/protectionContainers/{containerName}
 * ```
 * @property containerName Name of the container to be registered.
 * @property eTag Optional ETag.
 * @property fabricName Fabric name associated with the container.
 * @property location Resource location.
 * @property properties ProtectionContainerResource properties
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property tags Resource tags.
 * @property vaultName The name of the recovery services vault.
 */
public data class ProtectionContainerArgs(
    public val containerName: Output<String>? = null,
    public val eTag: Output<String>? = null,
    public val fabricName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ProtectionContainerArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ProtectionContainerArgs =
        com.pulumi.azurenative.recoveryservices.ProtectionContainerArgs.builder()
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectionContainerArgs].
 */
@PulumiTagMarker
public class ProtectionContainerArgsBuilder internal constructor() {
    private var containerName: Output<String>? = null

    private var eTag: Output<String>? = null

    private var fabricName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Name of the container to be registered.
     */
    @JvmName("dkccrgbwoawavblq")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("jrkcnfikliystanh")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Fabric name associated with the container.
     */
    @JvmName("urgvlitwtdqwkueg")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("euhxsveptrtmptun")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ProtectionContainerResource properties
     */
    @JvmName("uvdsfrykyagnibye")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("jjdoqjgqxjkfegtg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jndfymufxayunhye")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("ovedyqqtrcjdrjxh")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Name of the container to be registered.
     */
    @JvmName("fjfkuanxekcixieg")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("youjyqmfgnhielgp")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Fabric name associated with the container.
     */
    @JvmName("fqwugqrrmwslcord")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("gqvugdwnpktjnxay")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ProtectionContainerResource properties
     */
    @JvmName("xhwoptmqremkefkm")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("nvovmmmqulmhabpd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sqregxwtfggtjxmi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("eiiavdsiafigvovi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("ejnkuargcsswybga")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): ProtectionContainerArgs = ProtectionContainerArgs(
        containerName = containerName,
        eTag = eTag,
        fabricName = fabricName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
