@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ProtectionIntentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Base class for backup ProtectionIntent.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01, 2024-04-01, 2024-04-30-preview.
 * ## Example Usage
 * ### Create or Update Azure Vm Protection Intent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionIntent = new AzureNative.RecoveryServices.ProtectionIntent("protectionIntent", new()
 *     {
 *         FabricName = "Azure",
 *         IntentObjectName = "vm;iaasvmcontainerv2;chamsrgtest;chamscandel",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureResourceProtectionIntentArgs
 *         {
 *             PolicyId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.RecoveryServices/vaults/myVault/backupPolicies/myPolicy",
 *             ProtectionIntentItemType = "AzureResourceItem",
 *             SourceResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/chamsrgtest/providers/Microsoft.Compute/virtualMachines/chamscandel",
 *         },
 *         ResourceGroupName = "myRG",
 *         VaultName = "myVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionIntent(ctx, "protectionIntent", &recoveryservices.ProtectionIntentArgs{
 * 			FabricName:       pulumi.String("Azure"),
 * 			IntentObjectName: pulumi.String("vm;iaasvmcontainerv2;chamsrgtest;chamscandel"),
 * 			Properties: recoveryservices.AzureResourceProtectionIntent{
 * 				PolicyId:                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.RecoveryServices/vaults/myVault/backupPolicies/myPolicy",
 * 				ProtectionIntentItemType: "AzureResourceItem",
 * 				SourceResourceId:         "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/chamsrgtest/providers/Microsoft.Compute/virtualMachines/chamscandel",
 * 			},
 * 			ResourceGroupName: pulumi.String("myRG"),
 * 			VaultName:         pulumi.String("myVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionIntent;
 * import com.pulumi.azurenative.recoveryservices.ProtectionIntentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionIntent = new ProtectionIntent("protectionIntent", ProtectionIntentArgs.builder()
 *             .fabricName("Azure")
 *             .intentObjectName("vm;iaasvmcontainerv2;chamsrgtest;chamscandel")
 *             .properties(AzureRecoveryServiceVaultProtectionIntentArgs.builder()
 *                 .policyId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myRG/providers/Microsoft.RecoveryServices/vaults/myVault/backupPolicies/myPolicy")
 *                 .protectionIntentItemType("AzureResourceItem")
 *                 .sourceResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/chamsrgtest/providers/Microsoft.Compute/virtualMachines/chamscandel")
 *                 .build())
 *             .resourceGroupName("myRG")
 *             .vaultName("myVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ProtectionIntent vm;iaasvmcontainerv2;chamsrgtest;chamscandel /Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupFabrics/{fabricName}/backupProtectionIntent/{intentObjectName}
 * ```
 * @property eTag Optional ETag.
 * @property fabricName Fabric name associated with the backup item.
 * @property intentObjectName Intent object name.
 * @property location Resource location.
 * @property properties ProtectionIntentResource properties
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property tags Resource tags.
 * @property vaultName The name of the recovery services vault.
 */
public data class ProtectionIntentArgs(
    public val eTag: Output<String>? = null,
    public val fabricName: Output<String>? = null,
    public val intentObjectName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vaultName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ProtectionIntentArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ProtectionIntentArgs =
        com.pulumi.azurenative.recoveryservices.ProtectionIntentArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .intentObjectName(intentObjectName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProtectionIntentArgs].
 */
@PulumiTagMarker
public class ProtectionIntentArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var fabricName: Output<String>? = null

    private var intentObjectName: Output<String>? = null

    private var location: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vaultName: Output<String>? = null

    /**
     * @param value Optional ETag.
     */
    @JvmName("mnbfxwyspcktihpd")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Fabric name associated with the backup item.
     */
    @JvmName("mcsqxtrqecjebfua")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Intent object name.
     */
    @JvmName("pkepsawjeepoqanv")
    public suspend fun intentObjectName(`value`: Output<String>) {
        this.intentObjectName = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("lfdiynwcifnwfmbo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value ProtectionIntentResource properties
     */
    @JvmName("uejdpoilscoodskj")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("xnefnjnfbhsyhrbe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("uqivxcfnljvleqid")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("otnrvmeiawvwmypg")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("febygaesudocralm")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Fabric name associated with the backup item.
     */
    @JvmName("uoivrnjyleditxjd")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Intent object name.
     */
    @JvmName("kowtfhgeloepieto")
    public suspend fun intentObjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.intentObjectName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("jviyvhtpovbjvkfa")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value ProtectionIntentResource properties
     */
    @JvmName("frbqstrvqhvwaesn")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("nxmfmedlttpofuvm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ademadweemnugovu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gktdmbgcsyapxwmq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("slntitbpewhjpjuf")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    internal fun build(): ProtectionIntentArgs = ProtectionIntentArgs(
        eTag = eTag,
        fabricName = fabricName,
        intentObjectName = intentObjectName,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vaultName = vaultName,
    )
}
