@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ProtectionPolicy].
 */
@PulumiTagMarker
public class ProtectionPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProtectionPolicyArgs = ProtectionPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProtectionPolicyArgsBuilder.() -> Unit) {
        val builder = ProtectionPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProtectionPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ProtectionPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ProtectionPolicy(builtJavaResource)
    }
}

/**
 * Base class for backup policy. Workload-specific backup policies are derived from this class.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2016-06-01, 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01, 2024-04-01, 2024-04-30-preview.
 * ## Example Usage
 * ### Create or Update Daily Azure Storage Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "dailyPolicy2",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureFileShareProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureStorage",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 5,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Days,
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-09-29T08:00:00.000Z",
 *                     },
 *                 },
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 60,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Months,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-09-29T08:00:00.000Z",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 12,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Weeks,
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-09-29T08:00:00.000Z",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.January,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 10,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Years,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-09-29T08:00:00.000Z",
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *             {
 *                 SchedulePolicyType = "SimpleSchedulePolicy",
 *                 ScheduleRunFrequency = AzureNative.RecoveryServices.ScheduleRunType.Daily,
 *                 ScheduleRunTimes = new[]
 *                 {
 *                     "2021-09-29T08:00:00.000Z",
 *                 },
 *             },
 *             TimeZone = "UTC",
 *             WorkLoadType = AzureNative.RecoveryServices.WorkloadType.AzureFileShare,
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "swaggertestvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("dailyPolicy2"),
 * 			Properties: recoveryservices.AzureFileShareProtectionPolicy{
 * 				BackupManagementType: "AzureStorage",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        5,
 * 							DurationType: recoveryservices.RetentionDurationTypeDays,
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-09-29T08:00:00.000Z",
 * 						},
 * 					},
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        60,
 * 							DurationType: recoveryservices.RetentionDurationTypeMonths,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-09-29T08:00:00.000Z",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekSunday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        12,
 * 							DurationType: recoveryservices.RetentionDurationTypeWeeks,
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-09-29T08:00:00.000Z",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearJanuary,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        10,
 * 							DurationType: recoveryservices.RetentionDurationTypeYears,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-09-29T08:00:00.000Z",
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicy{
 * 					SchedulePolicyType:   "SimpleSchedulePolicy",
 * 					ScheduleRunFrequency: recoveryservices.ScheduleRunTypeDaily,
 * 					ScheduleRunTimes: []string{
 * 						"2021-09-29T08:00:00.000Z",
 * 					},
 * 				},
 * 				TimeZone:     "UTC",
 * 				WorkLoadType: recoveryservices.WorkloadTypeAzureFileShare,
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("swaggertestvault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("dailyPolicy2")
 *             .properties(AzureFileShareProtectionPolicyArgs.builder()
 *                 .backupManagementType("AzureStorage")
 *                 .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                     .dailySchedule(DailyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(5)
 *                             .durationType("Days")
 *                             .build())
 *                         .retentionTimes("2021-09-29T08:00:00.000Z")
 *                         .build())
 *                     .monthlySchedule(MonthlyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(60)
 *                             .durationType("Months")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .weeksOfTheMonth("First")
 *                             .build())
 *                         .retentionTimes("2021-09-29T08:00:00.000Z")
 *                         .build())
 *                     .retentionPolicyType("LongTermRetentionPolicy")
 *                     .weeklySchedule(WeeklyRetentionScheduleArgs.builder()
 *                         .daysOfTheWeek("Sunday")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(12)
 *                             .durationType("Weeks")
 *                             .build())
 *                         .retentionTimes("2021-09-29T08:00:00.000Z")
 *                         .build())
 *                     .yearlySchedule(YearlyRetentionScheduleArgs.builder()
 *                         .monthsOfYear("January")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(10)
 *                             .durationType("Years")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .weeksOfTheMonth("First")
 *                             .build())
 *                         .retentionTimes("2021-09-29T08:00:00.000Z")
 *                         .build())
 *                     .build())
 *                 .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                     .schedulePolicyType("SimpleSchedulePolicy")
 *                     .scheduleRunFrequency("Daily")
 *                     .scheduleRunTimes("2021-09-29T08:00:00.000Z")
 *                     .build())
 *                 .timeZone("UTC")
 *                 .workLoadType("AzureFileShare")
 *                 .build())
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("swaggertestvault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Enhanced Azure Vm Protection Policy with Hourly backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "v2-daily-sample",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSVMProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureIaasVM",
 *             InstantRpRetentionRangeInDays = 30,
 *             PolicyType = AzureNative.RecoveryServices.IAASVMPolicyType.V2,
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 180,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Days,
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 60,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Months,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 12,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Weeks,
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.January,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 10,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Years,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyV2Args
 *             {
 *                 HourlySchedule = new AzureNative.RecoveryServices.Inputs.HourlyScheduleArgs
 *                 {
 *                     Interval = 4,
 *                     ScheduleWindowDuration = 16,
 *                     ScheduleWindowStartTime = "2021-12-17T08:00:00Z",
 *                 },
 *                 SchedulePolicyType = "SimpleSchedulePolicyV2",
 *                 ScheduleRunFrequency = AzureNative.RecoveryServices.ScheduleRunType.Hourly,
 *             },
 *             TimeZone = "India Standard Time",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("v2-daily-sample"),
 * 			Properties: recoveryservices.AzureIaaSVMProtectionPolicy{
 * 				BackupManagementType:          "AzureIaasVM",
 * 				InstantRpRetentionRangeInDays: 30,
 * 				PolicyType:                    recoveryservices.IAASVMPolicyTypeV2,
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        180,
 * 							DurationType: recoveryservices.RetentionDurationTypeDays,
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        60,
 * 							DurationType: recoveryservices.RetentionDurationTypeMonths,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekSunday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        12,
 * 							DurationType: recoveryservices.RetentionDurationTypeWeeks,
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearJanuary,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        10,
 * 							DurationType: recoveryservices.RetentionDurationTypeYears,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicyV2{
 * 					HourlySchedule: recoveryservices.HourlySchedule{
 * 						Interval:                4,
 * 						ScheduleWindowDuration:  16,
 * 						ScheduleWindowStartTime: "2021-12-17T08:00:00Z",
 * 					},
 * 					SchedulePolicyType:   "SimpleSchedulePolicyV2",
 * 					ScheduleRunFrequency: recoveryservices.ScheduleRunTypeHourly,
 * 				},
 * 				TimeZone: "India Standard Time",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("v2-daily-sample")
 *             .properties(AzureFileShareProtectionPolicyArgs.builder()
 *                 .backupManagementType("AzureIaasVM")
 *                 .instantRpRetentionRangeInDays(30)
 *                 .policyType("V2")
 *                 .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                     .dailySchedule(DailyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(180)
 *                             .durationType("Days")
 *                             .build())
 *                         .retentionTimes("2021-12-17T08:00:00+00:00")
 *                         .build())
 *                     .monthlySchedule(MonthlyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(60)
 *                             .durationType("Months")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .weeksOfTheMonth("First")
 *                             .build())
 *                         .retentionTimes("2021-12-17T08:00:00+00:00")
 *                         .build())
 *                     .retentionPolicyType("LongTermRetentionPolicy")
 *                     .weeklySchedule(WeeklyRetentionScheduleArgs.builder()
 *                         .daysOfTheWeek("Sunday")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(12)
 *                             .durationType("Weeks")
 *                             .build())
 *                         .retentionTimes("2021-12-17T08:00:00+00:00")
 *                         .build())
 *                     .yearlySchedule(YearlyRetentionScheduleArgs.builder()
 *                         .monthsOfYear("January")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(10)
 *                             .durationType("Years")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .weeksOfTheMonth("First")
 *                             .build())
 *                         .retentionTimes("2021-12-17T08:00:00+00:00")
 *                         .build())
 *                     .build())
 *                 .schedulePolicy(SimpleSchedulePolicyV2Args.builder()
 *                     .hourlySchedule(HourlyScheduleArgs.builder()
 *                         .interval(4)
 *                         .scheduleWindowDuration(16)
 *                         .scheduleWindowStartTime("2021-12-17T08:00:00Z")
 *                         .build())
 *                     .schedulePolicyType("SimpleSchedulePolicyV2")
 *                     .scheduleRunFrequency("Hourly")
 *                     .build())
 *                 .timeZone("India Standard Time")
 *                 .build())
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Enhanced Azure Vm Protection Policy with daily backup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "v2-daily-sample",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSVMProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureIaasVM",
 *             InstantRpRetentionRangeInDays = 30,
 *             PolicyType = AzureNative.RecoveryServices.IAASVMPolicyType.V2,
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 180,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Days,
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 60,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Months,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 12,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Weeks,
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.January,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 10,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Years,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2021-12-17T08:00:00+00:00",
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyV2Args
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyScheduleArgs
 *                 {
 *                     ScheduleRunTimes = new[]
 *                     {
 *                         "2018-01-24T10:00:00Z",
 *                     },
 *                 },
 *                 SchedulePolicyType = "SimpleSchedulePolicyV2",
 *                 ScheduleRunFrequency = AzureNative.RecoveryServices.ScheduleRunType.Daily,
 *             },
 *             TimeZone = "India Standard Time",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("v2-daily-sample"),
 * 			Properties: recoveryservices.AzureIaaSVMProtectionPolicy{
 * 				BackupManagementType:          "AzureIaasVM",
 * 				InstantRpRetentionRangeInDays: 30,
 * 				PolicyType:                    recoveryservices.IAASVMPolicyTypeV2,
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        180,
 * 							DurationType: recoveryservices.RetentionDurationTypeDays,
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        60,
 * 							DurationType: recoveryservices.RetentionDurationTypeMonths,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekSunday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        12,
 * 							DurationType: recoveryservices.RetentionDurationTypeWeeks,
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearJanuary,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        10,
 * 							DurationType: recoveryservices.RetentionDurationTypeYears,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2021-12-17T08:00:00+00:00",
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicyV2{
 * 					DailySchedule: recoveryservices.DailySchedule{
 * 						ScheduleRunTimes: []string{
 * 							"2018-01-24T10:00:00Z",
 * 						},
 * 					},
 * 					SchedulePolicyType:   "SimpleSchedulePolicyV2",
 * 					ScheduleRunFrequency: recoveryservices.ScheduleRunTypeDaily,
 * 				},
 * 				TimeZone: "India Standard Time",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("v2-daily-sample")
 *             .properties(AzureFileShareProtectionPolicyArgs.builder()
 *                 .backupManagementType("AzureIaasVM")
 *                 .instantRpRetentionRangeInDays(30)
 *                 .policyType("V2")
 *                 .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                     .dailySchedule(DailyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(180)
 *                             .durationType("Days")
 *                             .build())
 *                         .retentionTimes("2021-12-17T08:00:00+00:00")
 *                         .build())
 *                     .monthlySchedule(MonthlyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(60)
 *                             .durationType("Months")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .weeksOfTheMonth("First")
 *                             .build())
 *                         .retentionTimes("2021-12-17T08:00:00+00:00")
 *                         .build())
 *                     .retentionPolicyType("LongTermRetentionPolicy")
 *                     .weeklySchedule(WeeklyRetentionScheduleArgs.builder()
 *                         .daysOfTheWeek("Sunday")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(12)
 *                             .durationType("Weeks")
 *                             .build())
 *                         .retentionTimes("2021-12-17T08:00:00+00:00")
 *                         .build())
 *                     .yearlySchedule(YearlyRetentionScheduleArgs.builder()
 *                         .monthsOfYear("January")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(10)
 *                             .durationType("Years")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .weeksOfTheMonth("First")
 *                             .build())
 *                         .retentionTimes("2021-12-17T08:00:00+00:00")
 *                         .build())
 *                     .build())
 *                 .schedulePolicy(SimpleSchedulePolicyV2Args.builder()
 *                     .dailySchedule(DailyScheduleArgs.builder()
 *                         .scheduleRunTimes("2018-01-24T10:00:00Z")
 *                         .build())
 *                     .schedulePolicyType("SimpleSchedulePolicyV2")
 *                     .scheduleRunFrequency("Daily")
 *                     .build())
 *                 .timeZone("India Standard Time")
 *                 .build())
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Full Azure Vm Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "testPolicy1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSVMProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureIaasVM",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 2,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Months,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Wednesday,
 *                             AzureNative.RecoveryServices.DayOfWeek.Thursday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                             AzureNative.RecoveryServices.WeekOfMonth.Third,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2018-01-24T10:00:00Z",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Monday,
 *                         AzureNative.RecoveryServices.DayOfWeek.Wednesday,
 *                         AzureNative.RecoveryServices.DayOfWeek.Thursday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 1,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Weeks,
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2018-01-24T10:00:00Z",
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.February,
 *                         AzureNative.RecoveryServices.MonthOfYear.November,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 4,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Years,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Monday,
 *                             AzureNative.RecoveryServices.DayOfWeek.Thursday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.Fourth,
 *                         },
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2018-01-24T10:00:00Z",
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *             {
 *                 SchedulePolicyType = "SimpleSchedulePolicy",
 *                 ScheduleRunDays = new[]
 *                 {
 *                     AzureNative.RecoveryServices.DayOfWeek.Monday,
 *                     AzureNative.RecoveryServices.DayOfWeek.Wednesday,
 *                     AzureNative.RecoveryServices.DayOfWeek.Thursday,
 *                 },
 *                 ScheduleRunFrequency = AzureNative.RecoveryServices.ScheduleRunType.Weekly,
 *                 ScheduleRunTimes = new[]
 *                 {
 *                     "2018-01-24T10:00:00Z",
 *                 },
 *             },
 *             TimeZone = "Pacific Standard Time",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("testPolicy1"),
 * 			Properties: recoveryservices.AzureIaaSVMProtectionPolicy{
 * 				BackupManagementType: "AzureIaasVM",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        2,
 * 							DurationType: recoveryservices.RetentionDurationTypeMonths,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekWednesday,
 * 								recoveryservices.DayOfWeekThursday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 								recoveryservices.WeekOfMonthThird,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2018-01-24T10:00:00Z",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekMonday,
 * 							recoveryservices.DayOfWeekWednesday,
 * 							recoveryservices.DayOfWeekThursday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        1,
 * 							DurationType: recoveryservices.RetentionDurationTypeWeeks,
 * 						},
 * 						RetentionTimes: []string{
 * 							"2018-01-24T10:00:00Z",
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearFebruary,
 * 							recoveryservices.MonthOfYearNovember,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        4,
 * 							DurationType: recoveryservices.RetentionDurationTypeYears,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekMonday,
 * 								recoveryservices.DayOfWeekThursday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFourth,
 * 							},
 * 						},
 * 						RetentionTimes: []string{
 * 							"2018-01-24T10:00:00Z",
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicy{
 * 					SchedulePolicyType: "SimpleSchedulePolicy",
 * 					ScheduleRunDays: []recoveryservices.DayOfWeek{
 * 						recoveryservices.DayOfWeekMonday,
 * 						recoveryservices.DayOfWeekWednesday,
 * 						recoveryservices.DayOfWeekThursday,
 * 					},
 * 					ScheduleRunFrequency: recoveryservices.ScheduleRunTypeWeekly,
 * 					ScheduleRunTimes: []string{
 * 						"2018-01-24T10:00:00Z",
 * 					},
 * 				},
 * 				TimeZone: "Pacific Standard Time",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("testPolicy1")
 *             .properties(AzureFileShareProtectionPolicyArgs.builder()
 *                 .backupManagementType("AzureIaasVM")
 *                 .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                     .monthlySchedule(MonthlyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(2)
 *                             .durationType("Months")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek(
 *                                 "Wednesday",
 *                                 "Thursday")
 *                             .weeksOfTheMonth(
 *                                 "First",
 *                                 "Third")
 *                             .build())
 *                         .retentionTimes("2018-01-24T10:00:00Z")
 *                         .build())
 *                     .retentionPolicyType("LongTermRetentionPolicy")
 *                     .weeklySchedule(WeeklyRetentionScheduleArgs.builder()
 *                         .daysOfTheWeek(
 *                             "Monday",
 *                             "Wednesday",
 *                             "Thursday")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(1)
 *                             .durationType("Weeks")
 *                             .build())
 *                         .retentionTimes("2018-01-24T10:00:00Z")
 *                         .build())
 *                     .yearlySchedule(YearlyRetentionScheduleArgs.builder()
 *                         .monthsOfYear(
 *                             "February",
 *                             "November")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(4)
 *                             .durationType("Years")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek(
 *                                 "Monday",
 *                                 "Thursday")
 *                             .weeksOfTheMonth("Fourth")
 *                             .build())
 *                         .retentionTimes("2018-01-24T10:00:00Z")
 *                         .build())
 *                     .build())
 *                 .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                     .schedulePolicyType("SimpleSchedulePolicy")
 *                     .scheduleRunDays(
 *                         "Monday",
 *                         "Wednesday",
 *                         "Thursday")
 *                     .scheduleRunFrequency("Weekly")
 *                     .scheduleRunTimes("2018-01-24T10:00:00Z")
 *                     .build())
 *                 .timeZone("Pacific Standard Time")
 *                 .build())
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Full Azure Workload Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "testPolicy1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureVmWorkloadProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureWorkload",
 *             Settings = new AzureNative.RecoveryServices.Inputs.SettingsArgs
 *             {
 *                 Issqlcompression = false,
 *                 TimeZone = "Pacific Standard Time",
 *             },
 *             SubProtectionPolicy = new[]
 *             {
 *                 new AzureNative.RecoveryServices.Inputs.SubProtectionPolicyArgs
 *                 {
 *                     PolicyType = AzureNative.RecoveryServices.PolicyType.Full,
 *                     RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *                     {
 *                         MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                         {
 *                             RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 1,
 *                                 DurationType = AzureNative.RecoveryServices.RetentionDurationType.Months,
 *                             },
 *                             RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                             RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                             {
 *                                 DaysOfTheWeek = new[]
 *                                 {
 *                                     AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                                 },
 *                                 WeeksOfTheMonth = new[]
 *                                 {
 *                                     AzureNative.RecoveryServices.WeekOfMonth.Second,
 *                                 },
 *                             },
 *                             RetentionTimes = new[]
 *                             {
 *                                 "2018-01-24T10:00:00Z",
 *                             },
 *                         },
 *                         RetentionPolicyType = "LongTermRetentionPolicy",
 *                         WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                         {
 *                             DaysOfTheWeek = new[]
 *                             {
 *                                 AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                                 AzureNative.RecoveryServices.DayOfWeek.Tuesday,
 *                             },
 *                             RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 2,
 *                                 DurationType = AzureNative.RecoveryServices.RetentionDurationType.Weeks,
 *                             },
 *                             RetentionTimes = new[]
 *                             {
 *                                 "2018-01-24T10:00:00Z",
 *                             },
 *                         },
 *                         YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                         {
 *                             MonthsOfYear = new[]
 *                             {
 *                                 AzureNative.RecoveryServices.MonthOfYear.January,
 *                                 AzureNative.RecoveryServices.MonthOfYear.June,
 *                                 AzureNative.RecoveryServices.MonthOfYear.December,
 *                             },
 *                             RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                             {
 *                                 Count = 1,
 *                                 DurationType = AzureNative.RecoveryServices.RetentionDurationType.Years,
 *                             },
 *                             RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                             RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                             {
 *                                 DaysOfTheWeek = new[]
 *                                 {
 *                                     AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                                 },
 *                                 WeeksOfTheMonth = new[]
 *                                 {
 *                                     AzureNative.RecoveryServices.WeekOfMonth.Last,
 *                                 },
 *                             },
 *                             RetentionTimes = new[]
 *                             {
 *                                 "2018-01-24T10:00:00Z",
 *                             },
 *                         },
 *                     },
 *                     SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *                     {
 *                         SchedulePolicyType = "SimpleSchedulePolicy",
 *                         ScheduleRunDays = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                             AzureNative.RecoveryServices.DayOfWeek.Tuesday,
 *                         },
 *                         ScheduleRunFrequency = AzureNative.RecoveryServices.ScheduleRunType.Weekly,
 *                         ScheduleRunTimes = new[]
 *                         {
 *                             "2018-01-24T10:00:00Z",
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.RecoveryServices.Inputs.SubProtectionPolicyArgs
 *                 {
 *                     PolicyType = AzureNative.RecoveryServices.PolicyType.Differential,
 *                     RetentionPolicy = new AzureNative.RecoveryServices.Inputs.SimpleRetentionPolicyArgs
 *                     {
 *                         RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 8,
 *                             DurationType = AzureNative.RecoveryServices.RetentionDurationType.Days,
 *                         },
 *                         RetentionPolicyType = "SimpleRetentionPolicy",
 *                     },
 *                     SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *                     {
 *                         SchedulePolicyType = "SimpleSchedulePolicy",
 *                         ScheduleRunDays = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Friday,
 *                         },
 *                         ScheduleRunFrequency = AzureNative.RecoveryServices.ScheduleRunType.Weekly,
 *                         ScheduleRunTimes = new[]
 *                         {
 *                             "2018-01-24T10:00:00Z",
 *                         },
 *                     },
 *                 },
 *                 new AzureNative.RecoveryServices.Inputs.SubProtectionPolicyArgs
 *                 {
 *                     PolicyType = AzureNative.RecoveryServices.PolicyType.Log,
 *                     RetentionPolicy = new AzureNative.RecoveryServices.Inputs.SimpleRetentionPolicyArgs
 *                     {
 *                         RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                         {
 *                             Count = 7,
 *                             DurationType = AzureNative.RecoveryServices.RetentionDurationType.Days,
 *                         },
 *                         RetentionPolicyType = "SimpleRetentionPolicy",
 *                     },
 *                     SchedulePolicy = new AzureNative.RecoveryServices.Inputs.LogSchedulePolicyArgs
 *                     {
 *                         ScheduleFrequencyInMins = 60,
 *                         SchedulePolicyType = "LogSchedulePolicy",
 *                     },
 *                 },
 *             },
 *             WorkLoadType = AzureNative.RecoveryServices.WorkloadType.SQLDataBase,
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("testPolicy1"),
 * 			Properties: recoveryservices.AzureVmWorkloadProtectionPolicy{
 * 				BackupManagementType: "AzureWorkload",
 * 				Settings: recoveryservices.Settings{
 * 					Issqlcompression: false,
 * 					TimeZone:         "Pacific Standard Time",
 * 				},
 * 				SubProtectionPolicy: []recoveryservices.SubProtectionPolicy{
 * 					{
 * 						PolicyType: recoveryservices.PolicyTypeFull,
 * 						RetentionPolicy: {
 * 							MonthlySchedule: {
 * 								RetentionDuration: {
 * 									Count:        1,
 * 									DurationType: recoveryservices.RetentionDurationTypeMonths,
 * 								},
 * 								RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 								RetentionScheduleWeekly: {
 * 									DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 										recoveryservices.DayOfWeekSunday,
 * 									},
 * 									WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 										recoveryservices.WeekOfMonthSecond,
 * 									},
 * 								},
 * 								RetentionTimes: []string{
 * 									"2018-01-24T10:00:00Z",
 * 								},
 * 							},
 * 							RetentionPolicyType: "LongTermRetentionPolicy",
 * 							WeeklySchedule: {
 * 								DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 									recoveryservices.DayOfWeekSunday,
 * 									recoveryservices.DayOfWeekTuesday,
 * 								},
 * 								RetentionDuration: {
 * 									Count:        2,
 * 									DurationType: recoveryservices.RetentionDurationTypeWeeks,
 * 								},
 * 								RetentionTimes: []string{
 * 									"2018-01-24T10:00:00Z",
 * 								},
 * 							},
 * 							YearlySchedule: {
 * 								MonthsOfYear: []recoveryservices.MonthOfYear{
 * 									recoveryservices.MonthOfYearJanuary,
 * 									recoveryservices.MonthOfYearJune,
 * 									recoveryservices.MonthOfYearDecember,
 * 								},
 * 								RetentionDuration: {
 * 									Count:        1,
 * 									DurationType: recoveryservices.RetentionDurationTypeYears,
 * 								},
 * 								RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 								RetentionScheduleWeekly: {
 * 									DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 										recoveryservices.DayOfWeekSunday,
 * 									},
 * 									WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 										recoveryservices.WeekOfMonthLast,
 * 									},
 * 								},
 * 								RetentionTimes: []string{
 * 									"2018-01-24T10:00:00Z",
 * 								},
 * 							},
 * 						},
 * 						SchedulePolicy: {
 * 							SchedulePolicyType: "SimpleSchedulePolicy",
 * 							ScheduleRunDays: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 								recoveryservices.DayOfWeekTuesday,
 * 							},
 * 							ScheduleRunFrequency: recoveryservices.ScheduleRunTypeWeekly,
 * 							ScheduleRunTimes: []string{
 * 								"2018-01-24T10:00:00Z",
 * 							},
 * 						},
 * 					},
 * 					{
 * 						PolicyType: recoveryservices.PolicyTypeDifferential,
 * 						RetentionPolicy: {
 * 							RetentionDuration: {
 * 								Count:        8,
 * 								DurationType: recoveryservices.RetentionDurationTypeDays,
 * 							},
 * 							RetentionPolicyType: "SimpleRetentionPolicy",
 * 						},
 * 						SchedulePolicy: {
 * 							SchedulePolicyType: "SimpleSchedulePolicy",
 * 							ScheduleRunDays: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekFriday,
 * 							},
 * 							ScheduleRunFrequency: recoveryservices.ScheduleRunTypeWeekly,
 * 							ScheduleRunTimes: []string{
 * 								"2018-01-24T10:00:00Z",
 * 							},
 * 						},
 * 					},
 * 					{
 * 						PolicyType: recoveryservices.PolicyTypeLog,
 * 						RetentionPolicy: {
 * 							RetentionDuration: {
 * 								Count:        7,
 * 								DurationType: recoveryservices.RetentionDurationTypeDays,
 * 							},
 * 							RetentionPolicyType: "SimpleRetentionPolicy",
 * 						},
 * 						SchedulePolicy: {
 * 							ScheduleFrequencyInMins: 60,
 * 							SchedulePolicyType:      "LogSchedulePolicy",
 * 						},
 * 					},
 * 				},
 * 				WorkLoadType: recoveryservices.WorkloadTypeSQLDataBase,
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("testPolicy1")
 *             .properties(AzureFileShareProtectionPolicyArgs.builder()
 *                 .backupManagementType("AzureWorkload")
 *                 .settings(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .subProtectionPolicy(
 *                     %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference),
 *                     %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference),
 *                     %!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                 .workLoadType("SQLDataBase")
 *                 .build())
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Hourly Azure Storage Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "newPolicy2",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureFileShareProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureStorage",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 5,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Days,
 *                     },
 *                 },
 *                 MonthlySchedule = new AzureNative.RecoveryServices.Inputs.MonthlyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 60,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Months,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *                 WeeklySchedule = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionScheduleArgs
 *                 {
 *                     DaysOfTheWeek = new[]
 *                     {
 *                         AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 12,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Weeks,
 *                     },
 *                 },
 *                 YearlySchedule = new AzureNative.RecoveryServices.Inputs.YearlyRetentionScheduleArgs
 *                 {
 *                     MonthsOfYear = new[]
 *                     {
 *                         AzureNative.RecoveryServices.MonthOfYear.January,
 *                     },
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 10,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Years,
 *                     },
 *                     RetentionScheduleFormatType = AzureNative.RecoveryServices.RetentionScheduleFormat.Weekly,
 *                     RetentionScheduleWeekly = new AzureNative.RecoveryServices.Inputs.WeeklyRetentionFormatArgs
 *                     {
 *                         DaysOfTheWeek = new[]
 *                         {
 *                             AzureNative.RecoveryServices.DayOfWeek.Sunday,
 *                         },
 *                         WeeksOfTheMonth = new[]
 *                         {
 *                             AzureNative.RecoveryServices.WeekOfMonth.First,
 *                         },
 *                     },
 *                 },
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *             {
 *                 HourlySchedule = new AzureNative.RecoveryServices.Inputs.HourlyScheduleArgs
 *                 {
 *                     Interval = 4,
 *                     ScheduleWindowDuration = 12,
 *                     ScheduleWindowStartTime = "2021-09-29T08:00:00.000Z",
 *                 },
 *                 SchedulePolicyType = "SimpleSchedulePolicy",
 *                 ScheduleRunFrequency = AzureNative.RecoveryServices.ScheduleRunType.Hourly,
 *             },
 *             TimeZone = "UTC",
 *             WorkLoadType = AzureNative.RecoveryServices.WorkloadType.AzureFileShare,
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "swaggertestvault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("newPolicy2"),
 * 			Properties: recoveryservices.AzureFileShareProtectionPolicy{
 * 				BackupManagementType: "AzureStorage",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        5,
 * 							DurationType: recoveryservices.RetentionDurationTypeDays,
 * 						},
 * 					},
 * 					MonthlySchedule: recoveryservices.MonthlyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        60,
 * 							DurationType: recoveryservices.RetentionDurationTypeMonths,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 					WeeklySchedule: recoveryservices.WeeklyRetentionSchedule{
 * 						DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 							recoveryservices.DayOfWeekSunday,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        12,
 * 							DurationType: recoveryservices.RetentionDurationTypeWeeks,
 * 						},
 * 					},
 * 					YearlySchedule: recoveryservices.YearlyRetentionSchedule{
 * 						MonthsOfYear: []recoveryservices.MonthOfYear{
 * 							recoveryservices.MonthOfYearJanuary,
 * 						},
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        10,
 * 							DurationType: recoveryservices.RetentionDurationTypeYears,
 * 						},
 * 						RetentionScheduleFormatType: recoveryservices.RetentionScheduleFormatWeekly,
 * 						RetentionScheduleWeekly: recoveryservices.WeeklyRetentionFormat{
 * 							DaysOfTheWeek: []recoveryservices.DayOfWeek{
 * 								recoveryservices.DayOfWeekSunday,
 * 							},
 * 							WeeksOfTheMonth: []recoveryservices.WeekOfMonth{
 * 								recoveryservices.WeekOfMonthFirst,
 * 							},
 * 						},
 * 					},
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicy{
 * 					HourlySchedule: recoveryservices.HourlySchedule{
 * 						Interval:                4,
 * 						ScheduleWindowDuration:  12,
 * 						ScheduleWindowStartTime: "2021-09-29T08:00:00.000Z",
 * 					},
 * 					SchedulePolicyType:   "SimpleSchedulePolicy",
 * 					ScheduleRunFrequency: recoveryservices.ScheduleRunTypeHourly,
 * 				},
 * 				TimeZone:     "UTC",
 * 				WorkLoadType: recoveryservices.WorkloadTypeAzureFileShare,
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("swaggertestvault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("newPolicy2")
 *             .properties(AzureFileShareProtectionPolicyArgs.builder()
 *                 .backupManagementType("AzureStorage")
 *                 .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                     .dailySchedule(DailyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(5)
 *                             .durationType("Days")
 *                             .build())
 *                         .build())
 *                     .monthlySchedule(MonthlyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(60)
 *                             .durationType("Months")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .weeksOfTheMonth("First")
 *                             .build())
 *                         .build())
 *                     .retentionPolicyType("LongTermRetentionPolicy")
 *                     .weeklySchedule(WeeklyRetentionScheduleArgs.builder()
 *                         .daysOfTheWeek("Sunday")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(12)
 *                             .durationType("Weeks")
 *                             .build())
 *                         .build())
 *                     .yearlySchedule(YearlyRetentionScheduleArgs.builder()
 *                         .monthsOfYear("January")
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(10)
 *                             .durationType("Years")
 *                             .build())
 *                         .retentionScheduleFormatType("Weekly")
 *                         .retentionScheduleWeekly(WeeklyRetentionFormatArgs.builder()
 *                             .daysOfTheWeek("Sunday")
 *                             .weeksOfTheMonth("First")
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                     .hourlySchedule(HourlyScheduleArgs.builder()
 *                         .interval(4)
 *                         .scheduleWindowDuration(12)
 *                         .scheduleWindowStartTime("2021-09-29T08:00:00.000Z")
 *                         .build())
 *                     .schedulePolicyType("SimpleSchedulePolicy")
 *                     .scheduleRunFrequency("Hourly")
 *                     .build())
 *                 .timeZone("UTC")
 *                 .workLoadType("AzureFileShare")
 *                 .build())
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("swaggertestvault")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or Update Simple Azure Vm Protection Policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var protectionPolicy = new AzureNative.RecoveryServices.ProtectionPolicy("protectionPolicy", new()
 *     {
 *         PolicyName = "testPolicy1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.AzureIaaSVMProtectionPolicyArgs
 *         {
 *             BackupManagementType = "AzureIaasVM",
 *             RetentionPolicy = new AzureNative.RecoveryServices.Inputs.LongTermRetentionPolicyArgs
 *             {
 *                 DailySchedule = new AzureNative.RecoveryServices.Inputs.DailyRetentionScheduleArgs
 *                 {
 *                     RetentionDuration = new AzureNative.RecoveryServices.Inputs.RetentionDurationArgs
 *                     {
 *                         Count = 1,
 *                         DurationType = AzureNative.RecoveryServices.RetentionDurationType.Days,
 *                     },
 *                     RetentionTimes = new[]
 *                     {
 *                         "2018-01-24T02:00:00Z",
 *                     },
 *                 },
 *                 RetentionPolicyType = "LongTermRetentionPolicy",
 *             },
 *             SchedulePolicy = new AzureNative.RecoveryServices.Inputs.SimpleSchedulePolicyArgs
 *             {
 *                 SchedulePolicyType = "SimpleSchedulePolicy",
 *                 ScheduleRunFrequency = AzureNative.RecoveryServices.ScheduleRunType.Daily,
 *                 ScheduleRunTimes = new[]
 *                 {
 *                     "2018-01-24T02:00:00Z",
 *                 },
 *             },
 *             TimeZone = "Pacific Standard Time",
 *         },
 *         ResourceGroupName = "SwaggerTestRg",
 *         VaultName = "NetSDKTestRsVault",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewProtectionPolicy(ctx, "protectionPolicy", &recoveryservices.ProtectionPolicyArgs{
 * 			PolicyName: pulumi.String("testPolicy1"),
 * 			Properties: recoveryservices.AzureIaaSVMProtectionPolicy{
 * 				BackupManagementType: "AzureIaasVM",
 * 				RetentionPolicy: recoveryservices.LongTermRetentionPolicy{
 * 					DailySchedule: recoveryservices.DailyRetentionSchedule{
 * 						RetentionDuration: recoveryservices.RetentionDuration{
 * 							Count:        1,
 * 							DurationType: recoveryservices.RetentionDurationTypeDays,
 * 						},
 * 						RetentionTimes: []string{
 * 							"2018-01-24T02:00:00Z",
 * 						},
 * 					},
 * 					RetentionPolicyType: "LongTermRetentionPolicy",
 * 				},
 * 				SchedulePolicy: recoveryservices.SimpleSchedulePolicy{
 * 					SchedulePolicyType:   "SimpleSchedulePolicy",
 * 					ScheduleRunFrequency: recoveryservices.ScheduleRunTypeDaily,
 * 					ScheduleRunTimes: []string{
 * 						"2018-01-24T02:00:00Z",
 * 					},
 * 				},
 * 				TimeZone: "Pacific Standard Time",
 * 			},
 * 			ResourceGroupName: pulumi.String("SwaggerTestRg"),
 * 			VaultName:         pulumi.String("NetSDKTestRsVault"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicy;
 * import com.pulumi.azurenative.recoveryservices.ProtectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var protectionPolicy = new ProtectionPolicy("protectionPolicy", ProtectionPolicyArgs.builder()
 *             .policyName("testPolicy1")
 *             .properties(AzureFileShareProtectionPolicyArgs.builder()
 *                 .backupManagementType("AzureIaasVM")
 *                 .retentionPolicy(LongTermRetentionPolicyArgs.builder()
 *                     .dailySchedule(DailyRetentionScheduleArgs.builder()
 *                         .retentionDuration(RetentionDurationArgs.builder()
 *                             .count(1)
 *                             .durationType("Days")
 *                             .build())
 *                         .retentionTimes("2018-01-24T02:00:00Z")
 *                         .build())
 *                     .retentionPolicyType("LongTermRetentionPolicy")
 *                     .build())
 *                 .schedulePolicy(SimpleSchedulePolicyArgs.builder()
 *                     .schedulePolicyType("SimpleSchedulePolicy")
 *                     .scheduleRunFrequency("Daily")
 *                     .scheduleRunTimes("2018-01-24T02:00:00Z")
 *                     .build())
 *                 .timeZone("Pacific Standard Time")
 *                 .build())
 *             .resourceGroupName("SwaggerTestRg")
 *             .vaultName("NetSDKTestRsVault")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ProtectionPolicy testPolicy1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupPolicies/{policyName}
 * ```
 */
public class ProtectionPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ProtectionPolicy,
) : KotlinCustomResource(javaResource, ProtectionPolicyMapper) {
    /**
     * Optional ETag.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name associated with the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ProtectionPolicyResource properties
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProtectionPolicyMapper : ResourceMapper<ProtectionPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ProtectionPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ProtectionPolicy = ProtectionPolicy(
        javaResource as
            com.pulumi.azurenative.recoveryservices.ProtectionPolicy,
    )
}

/**
 * @see [ProtectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProtectionPolicy].
 */
public suspend fun protectionPolicy(
    name: String,
    block: suspend ProtectionPolicyResourceBuilder.() -> Unit,
): ProtectionPolicy {
    val builder = ProtectionPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProtectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun protectionPolicy(name: String): ProtectionPolicy {
    val builder = ProtectionPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
