@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationFabricArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.FabricCreationInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.FabricCreationInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Fabric definition.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01.
 * ## Example Usage
 * ### Creates an Azure Site Recovery fabric.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationFabric = new AzureNative.RecoveryServices.ReplicationFabric("replicationFabric", new()
 *     {
 *         FabricName = "cloud1",
 *         Properties = new AzureNative.RecoveryServices.Inputs.FabricCreationInputPropertiesArgs
 *         {
 *             CustomDetails =
 *             {
 *                 { "instanceType", "FabricSpecificCreationInput" },
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationFabric(ctx, "replicationFabric", &recoveryservices.ReplicationFabricArgs{
 * FabricName: pulumi.String("cloud1"),
 * Properties: &recoveryservices.FabricCreationInputPropertiesArgs{
 * CustomDetails: interface{}{
 * InstanceType: pulumi.String("FabricSpecificCreationInput"),
 * },
 * },
 * ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * ResourceName: pulumi.String("vault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationFabric;
 * import com.pulumi.azurenative.recoveryservices.ReplicationFabricArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.FabricCreationInputPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationFabric = new ReplicationFabric("replicationFabric", ReplicationFabricArgs.builder()
 *             .fabricName("cloud1")
 *             .properties(FabricCreationInputPropertiesArgs.builder()
 *                 .customDetails(AzureFabricCreationInputArgs.builder()
 *                     .instanceType("FabricSpecificCreationInput")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationFabric cloud1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}
 * ```
 * @property fabricName Name of the ASR fabric.
 * @property properties Fabric creation input.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationFabricArgs(
    public val fabricName: Output<String>? = null,
    public val properties: Output<FabricCreationInputPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationFabricArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationFabricArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationFabricArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationFabricArgs].
 */
@PulumiTagMarker
public class ReplicationFabricArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var properties: Output<FabricCreationInputPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Name of the ASR fabric.
     */
    @JvmName("xbomelvruounydqf")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Fabric creation input.
     */
    @JvmName("casxpxblnctclwlo")
    public suspend fun properties(`value`: Output<FabricCreationInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("kqncwefhriasxxdi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("txootchclapeosyb")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Name of the ASR fabric.
     */
    @JvmName("gbpljcvtjhryddsm")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Fabric creation input.
     */
    @JvmName("iunmrlggkqnuebhq")
    public suspend fun properties(`value`: FabricCreationInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Fabric creation input.
     */
    @JvmName("kyhkjhqxcykytreb")
    public suspend fun properties(argument: suspend FabricCreationInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FabricCreationInputPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("xuljgklpplygffjn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("uxoidqvitlbqeffj")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationFabricArgs = ReplicationFabricArgs(
        fabricName = fabricName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
