@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationNetworkMappingArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.CreateNetworkMappingInputPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.CreateNetworkMappingInputPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Network Mapping model. Ideally it should have been possible to inherit this class from prev version in InheritedModels as long as there is no difference in structure or method signature. Since there were no base Models for certain fields and methods viz NetworkMappingProperties and Load with required return type, the class has been introduced in its entirety with references to base models to facilitate extensions in subsequent versions.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2018-07-10.
 * Other available API versions: 2021-03-01, 2023-06-01, 2023-08-01, 2024-01-01, 2024-02-01.
 * ## Example Usage
 * ### Creates network mapping.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationNetworkMapping = new AzureNative.RecoveryServices.ReplicationNetworkMapping("replicationNetworkMapping", new()
 *     {
 *         FabricName = "b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac",
 *         NetworkMappingName = "corpe2amap",
 *         NetworkName = "e2267b5c-2650-49bd-ab3f-d66aae694c06",
 *         Properties = new AzureNative.RecoveryServices.Inputs.CreateNetworkMappingInputPropertiesArgs
 *         {
 *             FabricSpecificDetails = new AzureNative.RecoveryServices.Inputs.VmmToAzureCreateNetworkMappingInputArgs
 *             {
 *                 InstanceType = "VmmToAzure",
 *             },
 *             RecoveryFabricName = "Microsoft Azure",
 *             RecoveryNetworkId = "/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai",
 *         },
 *         ResourceGroupName = "srcBvte2a14C27",
 *         ResourceName = "srce2avaultbvtaC27",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := recoveryservices.NewReplicationNetworkMapping(ctx, "replicationNetworkMapping", &recoveryservices.ReplicationNetworkMappingArgs{
 * 			FabricName:         pulumi.String("b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac"),
 * 			NetworkMappingName: pulumi.String("corpe2amap"),
 * 			NetworkName:        pulumi.String("e2267b5c-2650-49bd-ab3f-d66aae694c06"),
 * 			Properties: &recoveryservices.CreateNetworkMappingInputPropertiesArgs{
 * 				FabricSpecificDetails: recoveryservices.VmmToAzureCreateNetworkMappingInput{
 * 					InstanceType: "VmmToAzure",
 * 				},
 * 				RecoveryFabricName: pulumi.String("Microsoft Azure"),
 * 				RecoveryNetworkId:  pulumi.String("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai"),
 * 			},
 * 			ResourceGroupName: pulumi.String("srcBvte2a14C27"),
 * 			ResourceName:      pulumi.String("srce2avaultbvtaC27"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationNetworkMapping;
 * import com.pulumi.azurenative.recoveryservices.ReplicationNetworkMappingArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.CreateNetworkMappingInputPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationNetworkMapping = new ReplicationNetworkMapping("replicationNetworkMapping", ReplicationNetworkMappingArgs.builder()
 *             .fabricName("b0cef6e9a4437b81803d0b55ada4f700ab66caae59c35d62723a1589c0cd13ac")
 *             .networkMappingName("corpe2amap")
 *             .networkName("e2267b5c-2650-49bd-ab3f-d66aae694c06")
 *             .properties(CreateNetworkMappingInputPropertiesArgs.builder()
 *                 .fabricSpecificDetails(VmmToAzureCreateNetworkMappingInputArgs.builder()
 *                     .instanceType("VmmToAzure")
 *                     .build())
 *                 .recoveryFabricName("Microsoft Azure")
 *                 .recoveryNetworkId("/subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/siterecoveryProd1/providers/Microsoft.Network/virtualNetworks/vnetavrai")
 *                 .build())
 *             .resourceGroupName("srcBvte2a14C27")
 *             .resourceName("srce2avaultbvtaC27")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationNetworkMapping corpe2amap /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationNetworks/{networkName}/replicationNetworkMappings/{networkMappingName}
 * ```
 * @property fabricName Primary fabric name.
 * @property networkMappingName Network mapping name.
 * @property networkName Primary network name.
 * @property properties Input properties for creating network mapping.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationNetworkMappingArgs(
    public val fabricName: Output<String>? = null,
    public val networkMappingName: Output<String>? = null,
    public val networkName: Output<String>? = null,
    public val properties: Output<CreateNetworkMappingInputPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationNetworkMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationNetworkMappingArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationNetworkMappingArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .networkMappingName(networkMappingName?.applyValue({ args0 -> args0 }))
            .networkName(networkName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationNetworkMappingArgs].
 */
@PulumiTagMarker
public class ReplicationNetworkMappingArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var networkMappingName: Output<String>? = null

    private var networkName: Output<String>? = null

    private var properties: Output<CreateNetworkMappingInputPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Primary fabric name.
     */
    @JvmName("iwjbbffkcjjyyyor")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Network mapping name.
     */
    @JvmName("xbbtsasodinqrvrv")
    public suspend fun networkMappingName(`value`: Output<String>) {
        this.networkMappingName = value
    }

    /**
     * @param value Primary network name.
     */
    @JvmName("drcavyfdptvoecgn")
    public suspend fun networkName(`value`: Output<String>) {
        this.networkName = value
    }

    /**
     * @param value Input properties for creating network mapping.
     */
    @JvmName("pipqkliekiujocue")
    public suspend fun properties(`value`: Output<CreateNetworkMappingInputPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("inuxmrsafqodqhwu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("eoiljjahdgtvehfb")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Primary fabric name.
     */
    @JvmName("rujbdbmuujjdobvh")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Network mapping name.
     */
    @JvmName("genxyvanfqpceura")
    public suspend fun networkMappingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkMappingName = mapped
    }

    /**
     * @param value Primary network name.
     */
    @JvmName("cbrunnuapldpuubl")
    public suspend fun networkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkName = mapped
    }

    /**
     * @param value Input properties for creating network mapping.
     */
    @JvmName("jxltsyjtrpgkuwbs")
    public suspend fun properties(`value`: CreateNetworkMappingInputPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Input properties for creating network mapping.
     */
    @JvmName("bpwjubuxdnxhajbu")
    public suspend fun properties(argument: suspend CreateNetworkMappingInputPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CreateNetworkMappingInputPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("lcifvasknxihbiyf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("dihsirvrevhynfdx")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationNetworkMappingArgs = ReplicationNetworkMappingArgs(
        fabricName = fabricName,
        networkMappingName = networkMappingName,
        networkName = networkName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
