@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.kotlin.outputs.ReplicationProtectionClusterPropertiesResponse
import com.pulumi.azurenative.recoveryservices.kotlin.outputs.ReplicationProtectionClusterPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ReplicationProtectionCluster].
 */
@PulumiTagMarker
public class ReplicationProtectionClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReplicationProtectionClusterArgs = ReplicationProtectionClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReplicationProtectionClusterArgsBuilder.() -> Unit) {
        val builder = ReplicationProtectionClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReplicationProtectionCluster {
        val builtJavaResource =
            com.pulumi.azurenative.recoveryservices.ReplicationProtectionCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ReplicationProtectionCluster(builtJavaResource)
    }
}

/**
 * Replication protection Cluster.
 * Azure REST API version: 2024-02-01.
 * ## Example Usage
 * ### Create Replication protection Cluster.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationProtectionCluster = new AzureNative.RecoveryServices.ReplicationProtectionCluster("replicationProtectionCluster", new()
 *     {
 *         FabricName = "eastus",
 *         Properties = new AzureNative.RecoveryServices.Inputs.ReplicationProtectionClusterPropertiesArgs
 *         {
 *             PolicyId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/24-hour-retention-policy",
 *             ProviderSpecificDetails = new AzureNative.RecoveryServices.Inputs.A2AReplicationProtectionClusterDetailsArgs
 *             {
 *                 InstanceType = "A2A",
 *             },
 *             RecoveryContainerId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/centraluseuap/replicationProtectionContainers/centraluseuap-container",
 *         },
 *         ProtectionContainerName = "eastus-container",
 *         ReplicationProtectionClusterName = "cluster12",
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationProtectionCluster(ctx, "replicationProtectionCluster", &recoveryservices.ReplicationProtectionClusterArgs{
 * FabricName: pulumi.String("eastus"),
 * Properties: &recoveryservices.ReplicationProtectionClusterPropertiesArgs{
 * PolicyId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/24-hour-retention-policy"),
 * ProviderSpecificDetails: interface{}{
 * InstanceType: pulumi.String("A2A"),
 * },
 * RecoveryContainerId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/centraluseuap/replicationProtectionContainers/centraluseuap-container"),
 * },
 * ProtectionContainerName: pulumi.String("eastus-container"),
 * ReplicationProtectionClusterName: pulumi.String("cluster12"),
 * ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * ResourceName: pulumi.String("vault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectionCluster;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectionClusterArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.ReplicationProtectionClusterPropertiesArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.A2AReplicationProtectionClusterDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationProtectionCluster = new ReplicationProtectionCluster("replicationProtectionCluster", ReplicationProtectionClusterArgs.builder()
 *             .fabricName("eastus")
 *             .properties(ReplicationProtectionClusterPropertiesArgs.builder()
 *                 .policyId("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/24-hour-retention-policy")
 *                 .providerSpecificDetails(A2AReplicationProtectionClusterDetailsArgs.builder()
 *                     .instanceType("A2A")
 *                     .build())
 *                 .recoveryContainerId("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/centraluseuap/replicationProtectionContainers/centraluseuap-container")
 *                 .build())
 *             .protectionContainerName("eastus-container")
 *             .replicationProtectionClusterName("cluster12")
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationProtectionCluster cluster12 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionClusters/{replicationProtectionClusterName}
 * ```
 */
public class ReplicationProtectionCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.recoveryservices.ReplicationProtectionCluster,
) : KotlinCustomResource(javaResource, ReplicationProtectionClusterMapper) {
    /**
     * The name of the protection cluster.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The custom data.
     */
    public val properties: Output<ReplicationProtectionClusterPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The Type of the object.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReplicationProtectionClusterMapper : ResourceMapper<ReplicationProtectionCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.recoveryservices.ReplicationProtectionCluster::class == javaResource::class

    override fun map(javaResource: Resource): ReplicationProtectionCluster =
        ReplicationProtectionCluster(
            javaResource as
                com.pulumi.azurenative.recoveryservices.ReplicationProtectionCluster,
        )
}

/**
 * @see [ReplicationProtectionCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReplicationProtectionCluster].
 */
public suspend fun replicationProtectionCluster(
    name: String,
    block: suspend ReplicationProtectionClusterResourceBuilder.() -> Unit,
): ReplicationProtectionCluster {
    val builder = ReplicationProtectionClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReplicationProtectionCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun replicationProtectionCluster(name: String): ReplicationProtectionCluster {
    val builder = ReplicationProtectionClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
