@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin

import com.pulumi.azurenative.recoveryservices.ReplicationProtectionClusterArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.ReplicationProtectionClusterPropertiesArgs
import com.pulumi.azurenative.recoveryservices.kotlin.inputs.ReplicationProtectionClusterPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Replication protection Cluster.
 * Azure REST API version: 2024-02-01.
 * ## Example Usage
 * ### Create Replication protection Cluster.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationProtectionCluster = new AzureNative.RecoveryServices.ReplicationProtectionCluster("replicationProtectionCluster", new()
 *     {
 *         FabricName = "eastus",
 *         Properties = new AzureNative.RecoveryServices.Inputs.ReplicationProtectionClusterPropertiesArgs
 *         {
 *             PolicyId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/24-hour-retention-policy",
 *             ProviderSpecificDetails = new AzureNative.RecoveryServices.Inputs.A2AReplicationProtectionClusterDetailsArgs
 *             {
 *                 InstanceType = "A2A",
 *             },
 *             RecoveryContainerId = "/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/centraluseuap/replicationProtectionContainers/centraluseuap-container",
 *         },
 *         ProtectionContainerName = "eastus-container",
 *         ReplicationProtectionClusterName = "cluster12",
 *         ResourceGroupName = "resourceGroupPS1",
 *         ResourceName = "vault1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/recoveryservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := recoveryservices.NewReplicationProtectionCluster(ctx, "replicationProtectionCluster", &recoveryservices.ReplicationProtectionClusterArgs{
 * FabricName: pulumi.String("eastus"),
 * Properties: &recoveryservices.ReplicationProtectionClusterPropertiesArgs{
 * PolicyId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/24-hour-retention-policy"),
 * ProviderSpecificDetails: interface{}{
 * InstanceType: pulumi.String("A2A"),
 * },
 * RecoveryContainerId: pulumi.String("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/centraluseuap/replicationProtectionContainers/centraluseuap-container"),
 * },
 * ProtectionContainerName: pulumi.String("eastus-container"),
 * ReplicationProtectionClusterName: pulumi.String("cluster12"),
 * ResourceGroupName: pulumi.String("resourceGroupPS1"),
 * ResourceName: pulumi.String("vault1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectionCluster;
 * import com.pulumi.azurenative.recoveryservices.ReplicationProtectionClusterArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.ReplicationProtectionClusterPropertiesArgs;
 * import com.pulumi.azurenative.recoveryservices.inputs.A2AReplicationProtectionClusterDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationProtectionCluster = new ReplicationProtectionCluster("replicationProtectionCluster", ReplicationProtectionClusterArgs.builder()
 *             .fabricName("eastus")
 *             .properties(ReplicationProtectionClusterPropertiesArgs.builder()
 *                 .policyId("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationPolicies/24-hour-retention-policy")
 *                 .providerSpecificDetails(A2AReplicationProtectionClusterDetailsArgs.builder()
 *                     .instanceType("A2A")
 *                     .build())
 *                 .recoveryContainerId("/Subscriptions/c183865e-6077-46f2-a3b1-deb0f4f4650a/resourceGroups/resourceGroupPS1/providers/Microsoft.RecoveryServices/vaults/vault1/replicationFabrics/centraluseuap/replicationProtectionContainers/centraluseuap-container")
 *                 .build())
 *             .protectionContainerName("eastus-container")
 *             .replicationProtectionClusterName("cluster12")
 *             .resourceGroupName("resourceGroupPS1")
 *             .resourceName("vault1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:recoveryservices:ReplicationProtectionCluster cluster12 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectionClusters/{replicationProtectionClusterName}
 * ```
 * @property fabricName Fabric name.
 * @property properties The custom data.
 * @property protectionContainerName Protection container name.
 * @property replicationProtectionClusterName Replication protection cluster name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class ReplicationProtectionClusterArgs(
    public val fabricName: Output<String>? = null,
    public val properties: Output<ReplicationProtectionClusterPropertiesArgs>? = null,
    public val protectionContainerName: Output<String>? = null,
    public val replicationProtectionClusterName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.ReplicationProtectionClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.ReplicationProtectionClusterArgs =
        com.pulumi.azurenative.recoveryservices.ReplicationProtectionClusterArgs.builder()
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protectionContainerName(protectionContainerName?.applyValue({ args0 -> args0 }))
            .replicationProtectionClusterName(replicationProtectionClusterName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationProtectionClusterArgs].
 */
@PulumiTagMarker
public class ReplicationProtectionClusterArgsBuilder internal constructor() {
    private var fabricName: Output<String>? = null

    private var properties: Output<ReplicationProtectionClusterPropertiesArgs>? = null

    private var protectionContainerName: Output<String>? = null

    private var replicationProtectionClusterName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("gjqspybiofatgusn")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value The custom data.
     */
    @JvmName("yqtkopvxonkdlmoc")
    public suspend fun properties(`value`: Output<ReplicationProtectionClusterPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("ljnnglsgadrhpxea")
    public suspend fun protectionContainerName(`value`: Output<String>) {
        this.protectionContainerName = value
    }

    /**
     * @param value Replication protection cluster name.
     */
    @JvmName("glbtebvvexstklce")
    public suspend fun replicationProtectionClusterName(`value`: Output<String>) {
        this.replicationProtectionClusterName = value
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("vfytglwebfvgqplu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("oxhnpmdcdapccjid")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Fabric name.
     */
    @JvmName("jpobudtcnfnxltac")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value The custom data.
     */
    @JvmName("xeuwwlvtmgnpucvw")
    public suspend fun properties(`value`: ReplicationProtectionClusterPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The custom data.
     */
    @JvmName("mqspwfrmnwhhglee")
    public suspend fun properties(argument: suspend ReplicationProtectionClusterPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ReplicationProtectionClusterPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("wepepirvcrymqymv")
    public suspend fun protectionContainerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionContainerName = mapped
    }

    /**
     * @param value Replication protection cluster name.
     */
    @JvmName("uknfwwiersbrnxqh")
    public suspend fun replicationProtectionClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationProtectionClusterName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("hysglevnfsndfbfe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("ppajoqupiuvgwglr")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): ReplicationProtectionClusterArgs = ReplicationProtectionClusterArgs(
        fabricName = fabricName,
        properties = properties,
        protectionContainerName = protectionContainerName,
        replicationProtectionClusterName = replicationProtectionClusterName,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
